/*
    Text maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "abort.h"
#include "edit.h"
#include "find.h"
#include "general.h"
#include "repinfo.h"
#include "replace.h"
#include "misc/misc.h"
#include "orz/orzmdi.h"


gchar *replace_text[REPLACE_TEXT];          /* ja:置換する文字列 */


/******************************************************************************
*                                                                             *
* ja:置換関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:置換
    mode,モード                                                             */
void
replace_operation (gint mode)
{
  gboolean replace = FALSE;
  gint count = 0, page_num;
  GdkPoint select;
  ReplaceInfo ri;
  TmaidWindow *tmaid;

  page_num = gtk_notebook_get_current_page (GTK_NOTEBOOK (mdi));
  tmaid = orz_mdi_get_data (ORZ_MDI (mdi), page_num);
  select = tmaid->select;
  ri.arrow = find_arrow;
  ri.ignorecase = find_ignorecase;
  ri.dst = replace_text[0];
  /* ja:中断ボタン */
  abort_box_start ();
  while (mode != REPLACE_CANCEL
            && find_operation (tmaid, &tmaid->cursor, &select, find_text[0],
                                                    ri.arrow, ri.ignorecase))
    {
      gint bytes, data_pos;
      TmaidHistory *d;

      replace = TRUE;
      ri.arrow = (tmaid->select.y < tmaid->cursor.y)
                                        || (tmaid->select.y == tmaid->cursor.y
                                        && tmaid->select.x < tmaid->cursor.x);
      bytes = edit_get_sel_bytes (tmaid, &tmaid->select, &tmaid->cursor);
      if (mode != REPLACE_ALL)
        {
          ri.src = g_malloc (bytes + 1);
          edit_cpy_sel_mem (tmaid, &tmaid->select, &tmaid->cursor, ri.src);
          ri.src[bytes] = '\0';
          ri.start = tmaid->select;
          ri.end = tmaid->cursor;
          mode = repinfo_dialog (&ri);
          g_free (ri.src);
          if (mode == REPLACE_CANCEL || mode == REPLACE_NEXT)
            continue;
        }
      if (select.x >= 0 && tmaid->cursor.y == select.y && ri.arrow)
        data_pos = edit_get_data_pos (tmaid, select.x, select.y, FALSE);
      else
        data_pos = -1;
      d = edit_operation (tmaid, ri.dst, g_strlen (ri.dst), ri.arrow, TRUE);
      if (data_pos >= 0)
        select.x = edit_get_screen_pos (tmaid,
                            data_pos + g_strlen (ri.dst) - bytes, select.y);
      if (mode == REPLACE_OK || mode == REPLACE_ALL)
        count++;
      d->next = tmaid->undo;
      tmaid->undo = d;
    }
  /* ja:中断ボタン */
  abort_box_end ();
  if (replace)
    {
      orz_mdi_set_edited (ORZ_MDI (mdi), page_num, TRUE);
      if (mode == REPLACE_ALL)
        {
          GtkWidget *dialog;

          dialog = gtk_message_dialog_new (GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
                            _("%d strings were replaced"), count);
          g_signal_connect (G_OBJECT (dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
          gtk_dialog_run (GTK_DIALOG (dialog));
          gtk_widget_destroy (dialog);
        }
    }
  else
    {
      GtkWidget *dialog;

      dialog = gtk_message_dialog_new (GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
                            _("'%s' was not fount."), find_text[0]);
      g_signal_connect (G_OBJECT (dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
      gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
    }
  set_menu_bar (tmaid);
}
