/*
    misc
    copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __MISC_H__
#define __MISC_H__


#include "gcommon.h"


G_BEGIN_DECLS


#define MISC_CREATE_MENU_BAR       1
#define MISC_CREATE_MENU_SHELL     2
#define MISC_CREATE_MENU_SEPARATOR 3
#define MISC_CREATE_MENU_STOCK     4
#define MISC_CREATE_MENU_ITEM      5
#define MISC_CREATE_MENU_CHECK     6
#define MISC_CREATE_MENU_RADIO     7
#define MISC_CREATE_MENU_TERMINAL  0
#define MISC_CREATE_MENU_ELLIPSIS  8
#define MISC_CREATE_MENU_NOIMAGE   16
#define MISC_CREATE_MENU_DISABLE   32
#define MISC_CREATE_MENU_MASK      7


typedef struct _MiscCreateMenuEntry
{
  gchar *path;
  gchar *name;
  gchar *accel;
  const gchar **xpm;
  guint menu_type;
  void (*func) (GtkWidget *widget, gpointer user_data);
  gpointer user_data;
  GtkWidget *widget;
} MiscCreateMenuEntry;
typedef struct _MiscCreateToolbarEntry
{
  gchar *path;
  gchar *name;
  const gchar **xpm;
  void (*func) (GtkWidget *widget, gpointer user_data);
  gpointer user_data;
  GtkToolItem *tool_item;
} MiscCreateToolbarEntry;


/******************************************************************************
*                                                                             *
* ja:メニュー/ツールバー関数群                                                *
*                                                                             *
******************************************************************************/
/*  ja:メニューを作成する
        entries,メニュー構造体
    accel_group,アクセルグループ                                            */
void
misc_create_menu (MiscCreateMenuEntry *entries,
                  GtkAccelGroup       *accel_group);


/*  ja:メニューを検索する
    entries,メニュー構造体
       path,パス
        RET,メニューアイテム                                                */
GtkWidget *
misc_find_menu (MiscCreateMenuEntry *entries,
                const gchar         *path);


/*  ja:ツールバーを作成する
    entries,ツールバー構造体
        RET,ツールバー                                                      */
GtkWidget *
misc_create_toolbar (MiscCreateToolbarEntry *entries);


/*  ja:ツールバーを検索する
    entries,ツールバー構造体
       path,パス
        RET,ツールアイテム                                                  */
GtkToolItem *
misc_find_toolbar (MiscCreateToolbarEntry *entries,
                   const gchar            *path);


/******************************************************************************
*                                                                             *
* ja:特定ファイル関数群                                                       *
*                                                                             *
******************************************************************************/
/*  ja:ユーザ設定ファイルを取得する
    group,グループ
     name,アプリケーション名
     file,ファイル名
      RET,ユーザ設定ファイル                                                */
const gchar *
misc_spec_config (const gchar *group,
                  const gchar *name,
                  const gchar *file);


/*  ja:ロケールのディレクトリを取得する
    prgname,プログラム
        RET,ロケールのディレクトリ                                          */
const gchar *
misc_spec_locale (const gchar *prgname);


/******************************************************************************
*                                                                             *
* ja:クローズボタン関数群                                                     *
*                                                                             *
******************************************************************************/
/*  ja:クローズボタンのイメージを取得する
    RET,イメージ,NULL:エラー                                                */
GtkWidget *
misc_close_image (void);


/*  ja:クローズボタンを取得する
    RET,ボタン,NULL:エラー                                                  */
GtkWidget *
misc_close_button (void);


/******************************************************************************
*                                                                             *
* ja:低レベル関数群                                                           *
*                                                                             *
******************************************************************************/
/*  ja:mnemonicをテキストに変換する
    mnemonic,mnemonic
         RET,テキスト                                                       */
gchar *
misc_mnemonic_to_text (const gchar *mnemonic);


/*  ja:スクロールバーを設定する
       scroll,スクロールウイジット
         func,シグナル関数
    func_data,データ
          min,最小値
          max,最大値
         page,ページ
          pos,位置                                                          */
void
misc_set_scroll_bar (GtkWidget  *scroll,
                     GCallback   func,
                     gpointer    func_data,
                     const gint  min,
                     const gint  max,
                     const gint  page,
                     const gint  pos);


/*  ja:Windowの内容をスクロールする
    widget,ウイジット
        dx,X軸方向の移動
        dy,Y軸方向の移動
         x,スクロールする範囲の右上X座標
         y,スクロールする範囲の右上Y座標
     width,スクロールする範囲の幅
    height,スクロールする範囲の高さ                                         */
void
misc_scroll_window (GtkWidget  *widget,
                    const gint  dx,
                    const gint  dy,
                    const gint  x,
                    const gint  y,
                    const gint  width,
                    const gint  height);


/* ja:ESCが押されたとき */
gboolean
misc_dialog_key_press (GtkWidget   *widget,
                       GdkEventKey *event,
                       gpointer     user_data);


/******************************************************************************
*                                                                             *
* ja:数値文字列関数群                                                         *
*                                                                             *
******************************************************************************/
/*  ja:数値→文字列
    value,数値
    radix,基数
     wide,桁数(正:空白,負:0)
     flag,TRUE:符号あり,FALSE:符号なし
      RET,文字列                                                            */
gchar *
misc_str_from_val (const gint     value,
                   const gint     radix,
                   const gint     wide,
                   const gboolean flag);


/*  ja:文字列→数値
    value,数値
      str,文字列
    radix,基数
     flag,TRUE:符号あり,FALSE:符号なし
      RET,TRUE:正常終了,FALSE:エラー                                        */
gboolean
misc_str_to_val (gint           *value,
                 const gchar    *str,
                 const gint      radix,
                 const gboolean  flag);


/*  ja:数値→文字列
     value,数値
    divide,除算値
       RET,文字列                                                           */
gchar *
misc_str_from_float (const gint value,
                     const gint divide);


/*  ja:文字列→数値
     value,数値
    divide,除算値
      text,文字列
       RET,TRUE:正常終了,FALSE:エラー                                       */
gboolean
misc_str_to_float (gint        *value,
                   gint        *divide,
                   const gchar *text);


/*  ja:数列→文字列
    array,数列
     size,要素数
     bits,ビット数
    radix,基数
     wide,桁数(正:空白,負:0)
     flag,TRUE:符号あり,FALSE:符号なし
      RET,文字列                                                            */
gchar *
misc_str_from_array (gconstpointer  array,
                     const gsize    size,
                     const gint     bits,
                     const gint     radix,
                     const gint     wide,
                     const gboolean flag);


/*  ja:文字列→数列
     size,要素数
     bits,ビット数
     text,文字列
    radix,基数
     flag,TRUE:符号あり,FALSE:符号なし
      RET,数列                                                              */
gpointer
misc_str_to_array (gsize          *size,
                   const gint      bits,
                   const gchar    *text,
                   const gint      radix,
                   const gboolean  flag);


G_END_DECLS


#endif /* __MISC_H__ */
