/*
    Text maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __FILE_H__
#define __FILE_H__


#include "tmaid.h"


G_BEGIN_DECLS


/******************************************************************************
*                                                                             *
* ja:ファイル入力関数群                                                       *
*                                                                             *
******************************************************************************/
/*  ja:TXTファイルを開く
     file,ファイル名
    tmaid,ウインドウ情報                                                    */
void
file_open_text (const gchar *file,
                TmaidWindow *tmaid);


/*  ja:ファイルを開く
    file,ファイル名
     RET,ウインドウ情報                                                     */
TmaidWindow *
file_open_edit (const gchar *file);


/******************************************************************************
*                                                                             *
* ja:ファイル出力関数群                                                       *
*                                                                             *
******************************************************************************/
/*  TXTファイルを保存する
     file,ファイル名
    tmaid,ウインドウ情報
      RET,TRUE:正常終了,FALSE:エラー                                        */
gboolean
file_save_text (const gchar *file,
                TmaidWindow *tmaid);


G_END_DECLS


#endif /* __FILE_H__ */
