/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <string.h>
#include <gdk/gdkkeysyms.h>
#include "abort.h"
#include "edit.h"
#include "find.h"
#include "general.h"


gboolean find_arrow=TRUE;					/*  */
gboolean find_ignorecase=FALSE;				/*  */
gchar *find_text[32];						/* ʸ */
gint find_num=0;							/* ϿƤ븡ʸ */


/******************************************************************************
*                                                                             *
*                                                             *
*                                                                             *
******************************************************************************/
static gboolean find_clicked_ok;
static GtkWidget *dialog,*check,*combo,*radio1;


/* OKܥ󤬲줿 */
static void find_dialog_clicked(GtkWidget *widget,FIND *fd)
{
	fd->text=g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry)));
	fd->ignorecase=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check));
	fd->arrow=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio1));
	gtk_widget_destroy(dialog);
	find_clicked_ok=TRUE;
}


/* ȥ꡼ǥ꥿󤬲줿 */
static void find_dialog_activate(GtkWidget *widget,FIND *fd)
{
	if (strlen(gtk_entry_get_text(GTK_ENTRY(widget)))>0)
		find_dialog_clicked(widget,fd);
}


/* ȥ꡼ѹ줿 */
static void find_dialog_changed(GtkWidget *widget,GtkWidget *button)
{
	gtk_widget_set_sensitive(button,
							strlen(gtk_entry_get_text(GTK_ENTRY(widget)))>0);
}


/* ESC줿 */
static gboolean find_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


gboolean find_dialog(FIND *fd)
{
	gint i;
	GList *glist=NULL;
	GSList *group=NULL;
	GtkWidget *radio0,*button0,*button1,*frame0,*frame1,*hbox,*tbox,*vbox;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),_(""));
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
								GTK_SIGNAL_FUNC(find_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* ܥ */
	button0=gtk_button_new_with_label(_(""));
	button1=gtk_button_new_with_label(_(""));
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",find_dialog_clicked,fd);
	gtk_signal_connect_object(GTK_OBJECT(button1),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	/* åܥ */
	check=gtk_check_button_new_with_label(_("ʸ/ʸ̤"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),fd->ignorecase);
	/* ܥܥå */
	for (i=0;i<find_num;i++)
		glist=g_list_append(glist,find_text[i]);
	combo=gtk_combo_new();
	if (find_num>0) {
		gtk_combo_set_popdown_strings(GTK_COMBO(combo),glist);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),find_text[0]);
		gtk_editable_select_region(GTK_EDITABLE(GTK_COMBO(combo)->entry),0,-1);
	}
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(combo)->entry),"activate",
												find_dialog_activate,fd);
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(combo)->entry),"changed",
												find_dialog_changed,button0);
	/* 饸ܥ */
	radio0=gtk_radio_button_new_with_label(group,_(""));
	group=gtk_radio_button_group(GTK_RADIO_BUTTON(radio0));
	radio1=gtk_radio_button_new_with_label(group,_(""));
	group=gtk_radio_button_group(GTK_RADIO_BUTTON(radio1));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fd->arrow?radio1:radio0),
																		TRUE);
	/* ե졼ȥܥå */
	tbox=gtk_vbox_new(FALSE,0);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),
								gtk_label_new(_("ʸ")),FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),combo,TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,FALSE,FALSE,8);
	frame0=gtk_frame_new(_("ץ"));
	hbox=gtk_hbox_new(FALSE,0);
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),check,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,TRUE,TRUE,8);
	gtk_container_add(GTK_CONTAINER(frame0),hbox);
	frame1=gtk_frame_new(_(""));
	hbox=gtk_hbox_new(FALSE,0);
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),radio0,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(vbox),radio1,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,TRUE,TRUE,8);
	gtk_container_add(GTK_CONTAINER(frame1),hbox);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),frame0,TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(hbox),frame1,TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,TRUE,TRUE,8);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(tbox),hbox,FALSE,FALSE,8);
	gtk_container_add(GTK_CONTAINER(dialog),tbox);

	/* ɽ */
	gtk_widget_set_sensitive(button0,
			strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry)))>0);
	gtk_widget_grab_focus(GTK_COMBO(combo)->entry);
	find_clicked_ok=FALSE;

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	return find_clicked_ok;
}


/******************************************************************************
*                                                                             *
* ؿ                                                                  *
*                                                                             *
******************************************************************************/
/*	ʸμ
	  type,ʸ°ǼХåե,0:ANK,1:EUC1Х,2:EUC2Х
	  text,ʸ
	length,ǡ													*/
static void make_char_type(gint *type,gchar *text,gint length)
{
	gint i=0;

	while (i<length)
		if (iskanji(text[i])) {
			type[i++]=1;
			type[i++]=2;
		} else {
			type[i++]=0;
		}
}


/*	
	       ptw,TXTɥ
	     start,ϰ
	       end,ϰ(x=-1ʤϰϤʤ)
	      find,ʸ
	     arrow,TRUE:,FALSE:
	ignorecase,TRUE:ʸʸ̤,FALSE:ʸʸ̤ʤ	*/
void find_operation(TEXTWND *ptw,GdkPoint *start,GdkPoint *end,
								gchar *find,gboolean arrow,gboolean ignorecase)
{
	gboolean result;			/* Ӥη,TRUE:Ʊ,FALSE:ۤʤ */
	gchar *text;
	gint i=0,sx,sy;
	gint length0,length1=0;		/* ʸ(Хñ) */
	gint *buf=NULL,*type=NULL;
	LINEBUF *p,*q;
	GdkPoint cursor,select,top,st,ed,data;
	GtkWidget *dialog;

	st=*start;
	ed=*end;
	cursor=ptw->cursor;
	ptw->cursor.x=get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
	length0=strlen(find);
	text=g_malloc((length0+1)*sizeof(gchar));
	if (ptw->select.x>=0) {
		/* ϰϤ */
		select=ptw->select;
		ptw->select.x=-1;
		clear_sel(ptw,&select,&ptw->cursor);
	}
	if (ed.x>=0) {
		/* ̤ˤΤȤˤ̵ */
		i=get_sel_byte(&ptw->start,&ptw->off,&st,&ed,ptw->tab);
		if (i<=length0) {
			cpy_sel_mem(&ptw->start,&ptw->off,&st,&ed,ptw->tab,text);
			text[i]='\0';
			if (ignorecase)	/* ʸ/ʸ̤ */
				result=strcmp(find,text)==0;
			else			/* ʸ/ʸ̤ʤ */
				result=g_strcasecmp(find,text)==0;
			if (result)
				ed.x=-1;
		}
	}
	if (ed.x<0) {
		if (arrow) {
			ed.x=get_width(&ptw->start,&ptw->off,ptw->max-1,ptw->tab);
			ed.y=ptw->max-1;/*  */
		} else {
			ed.x=ed.y=0;/*  */
		}
	}
	if ((arrow && (ed.y<st.y || (st.y==ed.y && ed.x<=st.x)))
					|| (!arrow && (st.y<ed.y || (st.y==ed.y && st.x<=ed.x))))
		return;/* ϰϤ̷⤹Ȥ */
	/* ܥå */
	userbreak=TRUE;
	dialog=abort_dialog(_(""));
	gtk_grab_add(dialog);
	ed.x=get_data_pos(&ptw->start,&ptw->off,ed.x,ed.y,ptw->tab,FALSE);
	st.x=get_data_pos(&ptw->start,&ptw->off,st.x,st.y,ptw->tab,FALSE);
	p=get_line_buf(&ptw->start,&ptw->off,st.y);
	/* ƱʸӤ뤿ʸ */
	q=p;
	data=st;
	if (st.y<ed.y || (st.y==ed.y && st.x<ed.x)) {
		/* 夫鲼 */
		while (st.y<ed.y || (st.y==ed.y && st.x<ed.x)) {
			/* ХåեκǸʸä */
			while (length1<length0
						&& (data.y<ed.y || (data.y==ed.y && data.x<ed.x))) {
				if (data.x<q->length) {
					/* ʸ */
					if (data.x<q->length-1 && iskanji(q->text[data.x])) {
						memcpy(text+length1,q->text+data.x,sizeof(gchar)*2);
						length1+=2;
						data.x+=2;
					} else {
						text[length1]=q->text[data.x];
						length1++;
						data.x++;
					}
				} else {
					/*  */
					while (gtk_events_pending())
						gtk_main_iteration();
					if (!userbreak)
						goto loop;
					if (!q->margin) {
						text[length1]='\n';
						length1++;
					}
					data.x=0;
					data.y++;
					q=q->next;
				}
			}
			text[length1]='\0';
			/*  */
			if (ignorecase)	/* ʸ/ʸ̤ */
				result=strcmp(find,text)==0;
			else			/* ʸ/ʸ̤ʤ */
				result=g_strcasecmp(find,text)==0;
			if (result) {
				/* פȤ */
				if (p->margin && p->length<=st.x) {
					/* ޡΤȤˤϼιԤƬ */
					st.x=0;
					st.y++;
				}
				ptw->select.x=get_screen_pos(&ptw->start,&ptw->off,
														st.x,st.y,ptw->tab);
				ptw->select.y=st.y;
				if (q->margin && q->length<=data.x) {
					/* ޡΤȤˤϼιԤƬ */
					data.x=0;
					data.y++;
				}
				ptw->cursor.x=get_screen_pos(&ptw->start,&ptw->off,
													data.x,data.y,ptw->tab);
				ptw->cursor.y=data.y;
				break;
			}
			/* ХåեƬʸ˴ */
			if (iskanji(text[0])) {
				memmove(text,text+2,(length0-2)*sizeof(gchar));
				length1-=2;
				if (st.x<p->length) {
					st.x+=2;
				} else {
					st.x=2;
					st.y++;
					p=p->next;
				}
			} else {
				memmove(text,text+1,(length0-1)*sizeof(gchar));
				length1--;
				if (st.x<p->length) {
					st.x++;
				} else {
					st.x=p->margin?1:0;
					st.y++;
					p=p->next;
				}
			}
		}
	} else {
		/*  */
		if (p->length>0) {
			type=g_malloc(p->length*sizeof(gint));
			make_char_type(type,p->text,p->length);
		}
		buf=g_malloc(length0*sizeof(gint));
		while (ed.y<st.y || (st.y==ed.y && ed.x<st.x)) {
			/* Хåեκǽʸä */
			while (length1<length0
						&& (ed.y<data.y || (data.y==ed.y && ed.x<data.x))) {
				if (0<data.x) {
					/* ʸ */
					if (type[data.x-1]==2) {
						memmove(text+2,text,(length0-2)*sizeof(gchar));
						memmove(buf+2,buf,(length0-2)*sizeof(gint));
						memcpy(text,q->text+data.x-2,sizeof(gchar)*2);
						buf[0]=1;
						buf[1]=2;
						length1+=2;
						data.x-=2;
					} else {
						memmove(text+1,text,(length0-1)*sizeof(gchar));
						memmove(buf+1,buf,(length0-1)*sizeof(gchar));
						text[0]=q->text[data.x-1];
						buf[0]=0;
						length1++;
						data.x--;
					}
				} else {
					/*  */
					while (gtk_events_pending())
						gtk_main_iteration();
					if (!userbreak)
						goto loop;
					q=q->prev;
					type=g_realloc(type,q->length*sizeof(gint));
					make_char_type(type,q->text,q->length);
					if (!q->margin) {
						memmove(text+1,text,(length0-1)*sizeof(gchar));
						memmove(buf+1,buf,(length0-1)*sizeof(gint));
						text[0]='\n';
						buf[0]=0;
						length1++;
					}
					data.x=q->length;
					data.y--;
				}
			}
			text[length1]='\0';
			/*  */
			if (ignorecase)	/* ʸ/ʸ̤ */
				result=strcmp(find,text)==0;
			else			/* ʸ/ʸ̤ʤ */
				result=g_strcasecmp(find,text)==0;
			if (result) {
				/* פȤ */
				if (p->margin && p->length<=st.x) {
					/* ޡΤȤˤϼιԤƬ */
					st.x=0;
					st.y++;
				}
				ptw->select.x=get_screen_pos(&ptw->start,&ptw->off,
														st.x,st.y,ptw->tab);
				ptw->select.y=st.y;
				if (q->margin && q->length<=data.x) {
					/* ޡΤȤˤϼιԤƬ */
					data.x=0;
					data.y++;
				}
				ptw->cursor.x=get_screen_pos(&ptw->start,&ptw->off,
													data.x,data.y,ptw->tab);
				ptw->cursor.y=data.y;
				break;
			}
			/* ХåեκǸʸ˴ */
			if (buf[length1-1]==2) {
				length1-=2;
				if (st.x>0) {
					st.x-=2;
				} else {
					p=p->prev;
					st.x=p->length-2;
					st.y--;
				}
			} else {
				length1--;
				if (st.x>0) {
					st.x--;
				} else {
					p=p->prev;
					st.x=p->length-(p->margin?1:0);
					st.y--;
				}
			}
		}
	}
	loop:
	g_free(type);
	/* λ */
	gtk_grab_remove(dialog);
    gtk_widget_destroy(dialog);
	if (ptw->select.x>=0) {
		top=ptw->top;
		sx=MAX(ptw->drawing->allocation.width/ptw->fontsize,1);
		sy=MAX(ptw->drawing->allocation.height/(ptw->fontsize*2),1);
		if (ptw->cursor.x<ptw->top.x)
			ptw->top.x=ptw->cursor.x;
		else if (ptw->cursor.x-sx+1>ptw->top.x)
			ptw->top.x=ptw->cursor.x-sx+1;
		if (ptw->cursor.y<ptw->top.y)
			ptw->top.y=ptw->cursor.y;
		else if (ptw->cursor.y-sy+1>ptw->top.y)
			ptw->top.y=ptw->cursor.y-sy+1;
		move_text_window(ptw,&top);
		clear_sel(ptw,&ptw->select,&ptw->cursor);
		draw_caret(ptw,&cursor);
	}
}
