/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "edit.h"


/******************************************************************************
*                                                                             *
* Խؿ                                                                  *
*                                                                             *
******************************************************************************/
/*	饤Хåե
	start,饤Хåե
	  off,ߤyɸ
	    y,yɸ
	  RET,饤Хåե													*/
LINEBUF *get_line_buf(LINEBUF **start,gint *off,gint y)
{
	while (y<*off && (*start)->prev!=NULL) {
		*start=(*start)->prev;
		(*off)--;
	}
	while (*off<y && (*start)->next!=NULL) {
		*start=(*start)->next;
		(*off)++;
	}
	return *start;
}


/*	
	start,饤Хåե
	  off,ߤyɸ
	    y,
	  tab,
	  RET,																*/
gint get_width(LINEBUF **start,gint *off,gint y,gint tab)
{
	gint datapos=0,width=0;
	LINEBUF *p;

	p=get_line_buf(start,off,y);
	if (p->margin)
		while (datapos<p->length-1)
			if (p->text[datapos]=='\t') {
				width=(width/tab+1)*tab;
				datapos++;
			} else if (iskanji(p->text[datapos])) {
				if (datapos==p->length-2)
					break;
				width+=2;
				datapos+=2;
			} else {
				width++;
				datapos++;
			}
	else
		while (datapos<p->length)
			if (p->text[datapos]=='\t') {
				width=(width/tab+1)*tab;
				datapos++;
			} else if (datapos==p->length-1 || !iskanji(p->text[datapos])) {
				width++;
				datapos++;
			} else {
				width+=2;
				datapos+=2;
			}
	return width;
}


/*	
	ptw,TXTɥ
	RET,																*/
gint get_width_max(TEXTWND *ptw)
{
	gint y,datapos,width,max=0;
	LINEBUF *p;

	for (y=0,p=get_line_buf(&ptw->start,&ptw->off,ptw->top.y);
								y<ptw->drawing->allocation.height && p!=NULL;
												y+=ptw->fontsize*2,p=p->next) {
		width=0;
		for (datapos=0;datapos<p->length;datapos++)
			if (p->text[datapos]=='\t')
				width=(width/ptw->tab+1)*ptw->tab;
			else
				width++;
		if (width>max)
			max=width;
	}
	return max;
}


/*	åȤΥ饤Ȥ줿xɸ
	start,饤Хåե
	  off,ߤyɸ
	    x,xɸ
	    y,yɸ
	  tab,
	align,TRUE:˴󤻤,FALSE:˴󤻤
	  RET,ɸ																*/
gint get_align_pos(LINEBUF **start,gint *off,
										gint x,gint y,gint tab,gboolean align)
{
	gint datapos=0,screenpos=0;
	LINEBUF *p;

	p=get_line_buf(start,off,y);
	if (p->margin)
		while (screenpos<x && datapos<p->length-1)
			if (p->text[datapos]=='\t') {
				if (x<(screenpos/tab+1)*tab)
					return align?(screenpos/tab+1)*tab:screenpos;
				screenpos=(screenpos/tab+1)*tab;
				datapos++;
			} else if (datapos==p->length-1 || !iskanji(p->text[datapos])) {
				screenpos++;
				datapos++;
			} else if (datapos==p->length-2) {
				break;
			} else if (x<screenpos+2) {
				return align?screenpos+2:screenpos;
			} else {
				screenpos+=2;
				datapos+=2;
			}
	else
		while (screenpos<x && datapos<p->length)
			if (p->text[datapos]=='\t') {
				if (x<(screenpos/tab+1)*tab)
					return align?(screenpos/tab+1)*tab:screenpos;
				screenpos=(screenpos/tab+1)*tab;
				datapos++;
			} else if (datapos==p->length-1 || !iskanji(p->text[datapos])) {
				screenpos++;
				datapos++;
			} else if (x<screenpos+2) {
				return align?screenpos+2:screenpos;
			} else {
				screenpos+=2;
				datapos+=2;
			}
	return screenpos;
}


/*	̾κɸ饤ХåեΥɥ쥹
	start,饤Хåե
	  off,ߤyɸ
	    x,xɸ
	    y,yɸ
	  tab,
	align,TRUE:˴󤻤,FALSE:˴󤻤
	  RET,ɥ쥹															*/
gint get_data_pos(LINEBUF **start,gint *off,gint x,gint y,
													gint tab,gboolean align)
{
	gint datapos=0,screenpos=0;
	LINEBUF *p;

	p=get_line_buf(start,off,y);
	while (screenpos<x && datapos<p->length)
		if (p->text[datapos]=='\t') {
			screenpos=(screenpos/tab+1)*tab;
			if (x<screenpos)
				return align?datapos+1:datapos;
			datapos++;
		} else if (datapos==p->length-1 || !iskanji(p->text[datapos])) {
			screenpos++;
			datapos++;
		} else if (x<screenpos+2) {
			return align?datapos+2:datapos;
		} else {
			screenpos+=2;
			datapos+=2;
		}
	return MIN(datapos,p->length);
}


/*	饤ХåեΥɥ쥹̾κɸ
	start,饤Хåե
	  off,ߤyɸ
	    x,xɸ
	    y,yɸ
	  tab,
	  RET,ɸ																*/
gint get_screen_pos(LINEBUF **start,gint *off,gint x,gint y,gint tab)
{
	gint datapos,screenpos=0;
	LINEBUF *p;

	p=get_line_buf(start,off,y);
	for (datapos=0;datapos<x;datapos++)
		if (p->text[datapos]=='\t')
			screenpos=(screenpos/tab+1)*tab;
		else
			screenpos++;
	return screenpos;
}


/*	ʸʬ
	  text,ʸ
	length,ʸ
	   RET,ʬ																*/
guint get_char_type(gchar *text,gint length)
{
	if (length>1)
		return 4;
	if (('A'<=*text && *text<='Z') || ('a'<=*text && *text<='z'))
		return 2;
	if ('0'<=*text && *text<='9')
		return 1;
	return 0;
}


/*	ڤ
	start,饤Хåե
	  off,ߤyɸ
	    x,xɸ
	    y,yɸ
	  tab,
	 move,TRUE:˰ư,FALSE:˰ư
	  RET,ɸ																*/
gint get_move_pos(LINEBUF **start,gint *off,gint x,gint y,
														gint tab,gboolean move)
{
	gint i,datapos,length,*type;/* 0:1Хʸ,1:1Х,2Х */
	guint ct,ctype;
	LINEBUF *p;

	p=get_line_buf(start,off,y);
	if (move) {
		/* ذư */
		datapos=get_data_pos(start,off,x,y,tab,FALSE);
		length=datapos<p->length-1 && iskanji(p->text[datapos])?2:1;
		ctype=get_char_type(p->text+datapos,length);
		datapos+=length;
		while (datapos<p->length) {
			length=datapos<p->length-1 && iskanji(p->text[datapos])?2:1;
			ct=get_char_type(p->text+datapos,length);
			if ((ctype&ct)==0) {
				if (ct!=0)
					break;
				ctype=0;
			}
			datapos+=length;
		}
	} else {
		/* ذư */
		datapos=get_data_pos(start,off,x,y,tab,FALSE);
		if (datapos<=0)
			return 0;
		type=g_malloc(datapos*sizeof(gint));
		i=0;
		while (i<datapos)
			if (i+1<datapos && iskanji(p->text[i])) {
				type[i++]=1;
				type[i++]=2;
			} else {
				type[i++]=0;
			}
		length=type[datapos-1]>0?2:1;
		datapos-=length;
		ctype=get_char_type(p->text+datapos,length);
		while (--datapos>=0) {
			if (type[datapos]>1)
				continue;
			length=type[datapos]>0?2:1;
			ct=get_char_type(p->text+datapos,length);
			if ((ctype&ct)==0) {
				if (ctype!=0) {
					datapos+=length;
					break;
				}
				ctype=ct;
			}
		}
		g_free(type);
	}
	return get_screen_pos(start,off,datapos,y,tab);
}


/*	ϰϤΥХȿ
	  start,饤Хåե
	    off,ߤyɸ
	start_p,ϰ
	  end_p,ϰ
	    tab,
	    RET,Хȿ														*/
gint get_sel_byte(LINEBUF **start,gint *off,
									GdkPoint *start_p,GdkPoint *end_p,gint tab)
{
	gint i,stpos,edpos,length;
	LINEBUF *p;
	GdkPoint st,ed;

	if (start_p->y<end_p->y || (start_p->y==end_p->y && start_p->x<end_p->x)) {
		st=*start_p;
		ed=*end_p;
	} else {
		st=*end_p;
		ed=*start_p;
	}
	stpos=get_data_pos(start,off,st.x,st.y,tab,FALSE);
	edpos=get_data_pos(start,off,ed.x,ed.y,tab,FALSE);
	if (st.y==ed.y) {
		/* Ʊ */
		length=edpos-stpos;
	} else {
		/* 㤦 */
		p=get_line_buf(start,off,st.y);
		length=p->length-stpos+edpos+(p->margin?0:1);
		for (i=st.y+1,p=p->next;i<ed.y && p!=NULL;i++,p=p->next)
			length+=p->length+(p->margin?0:1);
	}
	return length;
}


/*	ϰϤ˥ԡ
	  start,饤Хåե
	    off,ߤyɸ
	start_p,ϰ
	  end_p,ϰ
	    tab,
	   text,															*/
void cpy_sel_mem(LINEBUF **start,gint *off,
						GdkPoint *start_p,GdkPoint *end_p,gint tab,gchar *text)
{
	gint i,stpos,edpos,length;
	LINEBUF *p;
	GdkPoint st,ed;

	if (start_p->y<end_p->y || (start_p->y==end_p->y && start_p->x<end_p->x)) {
		st=*start_p;
		ed=*end_p;
	} else {
		st=*end_p;
		ed=*start_p;
	}
	stpos=get_data_pos(start,off,st.x,st.y,tab,FALSE);
	edpos=get_data_pos(start,off,ed.x,ed.y,tab,FALSE);
	p=get_line_buf(start,off,st.y);
	if (st.y==ed.y) {
		/* Ʊ */
		memcpy(text,p->text+stpos,(edpos-stpos)*sizeof(gchar));
	} else {
		/* 㤦 */
		length=p->length-stpos;
		memcpy(text,p->text+stpos,length*sizeof(gchar));
		if (!p->margin) {
			memcpy(text+length,"\n",sizeof(gchar));
			length++;
		}
		for (i=st.y+1,p=p->next;i<ed.y && p!=NULL;i++,p=p->next) {
			memcpy(text+length,p->text,p->length*sizeof(gchar));
			length+=p->length;
			if (!p->margin) {
				/*  */
				memcpy(text+length,"\n",sizeof(gchar));
				length++;
			}
		}
		memcpy(text+length,p->text,edpos*sizeof(gchar));
	}
}


/*	ƤŽդ
	 start,饤Хåե
	   off,ߤyɸ
	   put,Žդɸ
	   new,ɸ
	   tab,
	  text,
	length,Хȿ
	margin,ޡ(0ʤޤ֤ʤ)
	   RET,줿Կ													*/
gint put_mem(LINEBUF **start,gint *off,GdkPoint *put,GdkPoint *new,
								gint tab,gchar *text,gint length,gint margin)
{
	gint i=0,temp_leng,insert=0,datapos,screenpos;
	LINEBUF *p,*q;
	gchar *temp;

	datapos=get_data_pos(start,off,put->x,put->y,tab,FALSE);
	p=get_line_buf(start,off,put->y);
	if (datapos<=0 && p->prev!=NULL && p->prev->margin && length>=1
									&& memcmp(text,"\n",sizeof(gchar))==0) {
		/* ƬؤιԤޤ֤ƤꡢʸԤΤȤ */
		p=p->prev;
		datapos=p->length;
		put->x=get_screen_pos(start,off,p->length,--put->y,tab);
		/* ιԤαüذư */
	}
	if (datapos<p->length) {
		/* ְʹߤʸХåե¸ */
		temp_leng=p->length-datapos;
		temp=g_malloc(temp_leng*sizeof(gchar));
		memcpy(temp,p->text+datapos,temp_leng*sizeof(gchar));
		p->length=datapos;
	} else {
		temp_leng=0;
		temp=NULL;
	}
	if (margin>0) {
		/* ޡޤ֤ */
		screenpos=0;
		for (datapos=0;datapos<p->length;datapos++)
			if (p->text[datapos]=='\t')
				screenpos=(screenpos/tab+1)*tab;
			else
				screenpos++;
		while (i<length) {
			datapos=i;
			while (datapos<length && text[datapos]!='\n')
				if (text[datapos]=='\t') {
					screenpos=(screenpos/tab+1)*tab;
					if (margin<screenpos)
						break;
					datapos++;
				} else if (datapos==length-1 || !iskanji(text[datapos])) {
					screenpos++;
					if (margin<screenpos)
						break;
					datapos++;
				} else {
					screenpos+=2;
					if (margin<screenpos)
						break;
					datapos+=2;
				}
			if (p->length>0 || i!=datapos)
				p->text=g_realloc(p->text,(p->length+datapos-i)*sizeof(gchar));
			memcpy(p->text+p->length,text+i,(datapos-i)*sizeof(gchar));
			p->length+=datapos-i;
			if (length<=datapos) {
				i=datapos;
			} else {
				q=g_malloc(sizeof(LINEBUF));
				q->length=0;
				q->margin=p->margin;
				q->text=NULL;
				q->prev=p;
				q->next=p->next;
				p->next=q;
				if (q->next!=NULL)
					q->next->prev=q;
				if (datapos<=length-1 && text[datapos]=='\n') {
					/*  */
					i=datapos+1;
					p->margin=FALSE;
				} else {
					/*  */
					i=datapos;
					p->margin=TRUE;
				}
				p=q;
				screenpos=0;
				insert++;
			}
		}
	} else {
		/* ޡޤ֤ʤ */
		while (i<length) {
			for (datapos=i;datapos<length && text[datapos]!='\n';datapos++);
			if (p->length>0 || i!=datapos)
				p->text=g_realloc(p->text,(p->length+datapos-i)*sizeof(gchar));
			memcpy(p->text+p->length,text+i,(datapos-i)*sizeof(gchar));
			p->length+=datapos-i;
			if (length<=datapos) {
				i=datapos;
			} else {
				i=datapos+1;
				q=g_malloc(sizeof(LINEBUF));
				q->length=0;
				q->margin=FALSE;
				q->text=NULL;
				q->prev=p;
				q->next=p->next;
				p->next=q;
				if (q->next!=NULL)
					q->next->prev=q;
				p=q;
				insert++;
			}
		}
	}
	if (new!=NULL) {
		new->x=0;
		for (datapos=0;datapos<p->length;datapos++)
			if (p->text[datapos]=='\t')
				new->x=(new->x/tab+1)*tab;
			else
				new->x++;
		new->y=put->y+insert;
		if (margin>0 && p->margin && (margin<=new->x
					|| (temp!=NULL && margin-1<=new->x && iskanji(temp[0])))) {
			new->x=0;
			new->y++;
		}
	}
	if (temp!=NULL) {
		/* ְʹߤʸ᤹ */
		p->text=g_realloc(p->text,p->length+temp_leng);
		memcpy(p->text+p->length,temp,temp_leng*sizeof(gchar));
		p->length+=temp_leng;
		g_free(temp);
	}
	if (margin>0)
		/* ޡޤ֤ */
		while (p!=NULL) {
			datapos=screenpos=0;
			while (datapos<p->length)
				if (p->text[datapos]=='\t') {
					screenpos=(screenpos/tab+1)*tab;
					if (margin<screenpos)
						break;
					datapos++;
				} else if (datapos==p->length-1
											|| !iskanji(p->text[datapos])) {
					screenpos++;
					if (margin<screenpos)
						break;
					datapos++;
				} else {
					screenpos+=2;
					if (margin<screenpos)
						break;
					datapos+=2;
				}
			if (margin<screenpos) {
				/* ޡĶƤȤԤ */
				q=g_malloc(sizeof(LINEBUF));
				q->length=p->length-datapos;
				q->margin=p->margin;
				q->text=g_malloc(q->length*sizeof(gchar));
				q->prev=p;
				q->next=p->next;
				p->next=q;
				if (q->next!=NULL)
					q->next->prev=q;
				memcpy(q->text,p->text+datapos,q->length*sizeof(gchar));
				p->length=datapos;
				p->margin=TRUE;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				p=q;
				insert++;
			} else if (screenpos<margin && p->margin && p->next!=NULL) {
				/* ޡ򲼲굼ԤΤȤιԤȤ碌 */
				datapos=p->length;
				q=p->next;
				if (q->next!=NULL)
					q->next->prev=p;
				p->next=q->next;
				p->length+=q->length;
				p->margin=q->margin;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				memcpy(p->text+datapos,q->text,q->length*sizeof(gchar));
				g_free(q->text);
				g_free(q);
				insert--;
			} else {
				break;
			}
		}
	return insert;
}


/*	ϰϤ
	  start,饤Хåե
	    off,ߤyɸ
	start_p,ϰ
	  end_p,ϰ
	    tab,
	 margin,ޡ(0ʤޤ֤ʤ)
	    RET,줿Կ													*/
gint del_sel_mem(LINEBUF **start,gint *off,
						GdkPoint *start_p,GdkPoint *end_p,gint tab,gint margin)
{
	gint i,stpos,edpos,delete,datapos,screenpos;
	LINEBUF *p,*q,*r;
	GdkPoint st,ed;

	if (start_p->y<end_p->y || (start_p->y==end_p->y && start_p->x<end_p->x)) {
		st=*start_p;
		ed=*end_p;
	} else {
		st=*end_p;
		ed=*start_p;
	}
	stpos=get_data_pos(start,off,st.x,st.y,tab,FALSE);
	edpos=get_data_pos(start,off,ed.x,ed.y,tab,FALSE);
	p=get_line_buf(start,off,st.y);
	if (st.y==ed.y) {
		/* Ʊ */
		memcpy(p->text+stpos,p->text+edpos,(p->length-edpos)*sizeof(gchar));
		p->length-=edpos-stpos;
		p->text=g_realloc(p->text,p->length);
		delete=0;
	} else {
		/* 㤦 */
		for (i=st.y+1,q=p->next;i<ed.y && q!=NULL;i++,q=r) {
			g_free(q->text);
			r=q->next;
			g_free(q);
		}
		if (q->next!=NULL)
			q->next->prev=p;
		p->next=q->next;
		p->length=stpos+q->length-edpos;
		p->margin=q->margin;
		p->text=g_realloc(p->text,p->length);
		memcpy(p->text+stpos,q->text+edpos,(q->length-edpos)*sizeof(gchar));
		g_free(q->text);
		g_free(q);
		delete=ed.y-st.y;
	}
	q=p->prev;
	if (q!=NULL && q->margin && st.x<=0) {
		/* ιԤԤǺϤƬΤȤ */
		if (p->length>0) {
			datapos=screenpos=0;
			while (datapos<q->length)
				if (q->text[datapos]=='\t') {
					screenpos=(screenpos/tab+1)*tab;
					datapos++;
				} else if (iskanji(q->text[datapos])) {
					screenpos+=2;
					datapos+=2;
				} else {
					screenpos++;
					datapos++;
				}
			if (p->text[0]=='\t')
				screenpos=(screenpos/tab+1)*tab;
			else if (iskanji(p->text[0]))
				screenpos+=2;
			else
				screenpos++;
		} else {
			screenpos=0;
		}
		if (p->length<=0 || screenpos<=margin) {
			/* ޡ򲼲굼ԤΤȤιԤȤ碌 */
			datapos=q->length;
			if (p->next!=NULL)
				p->next->prev=q;
			q->next=p->next;
			q->length+=p->length;
			q->margin=p->margin;
			q->text=g_realloc(q->text,q->length*sizeof(gchar));
			memcpy(q->text+datapos,p->text,p->length*sizeof(gchar));
			g_free(p->text);
			g_free(p);
			delete++;
			p=q;
			if (start_p->y<end_p->y
							|| (start_p->y==end_p->y && start_p->x<end_p->x)) {
				start_p->x=screenpos;
				start_p->y--;
			} else {
				end_p->x=screenpos;
				end_p->y--;
			}
		}
	}
	if (margin>0)
		/* ޡޤ֤ */
		while (p!=NULL) {
			datapos=screenpos=0;
			while (datapos<p->length)
				if (p->text[datapos]=='\t') {
					screenpos=(screenpos/tab+1)*tab;
					if (margin<screenpos)
						break;
					datapos++;
				} else if (datapos==p->length-1
											|| !iskanji(p->text[datapos])) {
					screenpos++;
					if (margin<screenpos)
						break;
					datapos++;
				} else {
					screenpos+=2;
					if (margin<screenpos)
						break;
					datapos+=2;
				}
			if (margin<screenpos) {
				/* ޡĶƤȤԤ */
				q=g_malloc(sizeof(LINEBUF));
				q->length=p->length-datapos;
				q->margin=p->margin;
				q->text=g_malloc(q->length*sizeof(gchar));
				q->prev=p;
				q->next=p->next;
				p->next=q;
				if (q->next!=NULL)
					q->next->prev=q;
				memcpy(q->text,p->text+datapos,q->length*sizeof(gchar));
				p->length=datapos;
				p->margin=TRUE;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				p=q;
				delete--;
			} else if (screenpos<margin && p->margin && p->next!=NULL) {
				/* ޡ򲼲굼ԤΤȤιԤȤ碌 */
				datapos=p->length;
				q=p->next;
				if (q->next!=NULL)
					q->next->prev=p;
				p->next=q->next;
				p->length+=q->length;
				p->margin=q->margin;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				memcpy(p->text+datapos,q->text,q->length*sizeof(gchar));
				g_free(q->text);
				g_free(q);
				delete++;
			} else if (!p->margin) {
				break;
			} else {
				p=p->next;
			}
		}
	return delete;
}
