/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __TMAID_H__
#define __TMAID_H__


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include <gtk/gtk.h>
#include "intl.h"


#define MENUFILE 10
#define iskanji(ch) (((ch)&0x80)!=0)


typedef struct ftype {
	gchar *text,*ext;			/* O,gq */
	gchar *fontname;			/* tHg */
	gboolean create;			/* TRUE:VK쐬,FALSE:t@C */
	gboolean edit;				/* TRUE:ҏWς,FALSE:ҏW */
	gboolean code;				/* TRUE:^ũR[h\ */
	gboolean crlf;				/* TRUE:sR[h\ */
	gboolean eof;				/* TRUE:1Aht@C̖ɏ */
	gboolean limit;				/* TRUE:E}[WŐ܂Ԃ */
	gboolean overwrite;			/* TRUE:t@C㏑ƂɊmF */
	gboolean space;				/* TRUE:Xy[XDF̎lpŕ\ */
	gboolean gline;				/* TRUE:Obh\ */
	gboolean mline;				/* TRUE:E}[W\ */
	gboolean uline;				/* TRUE:^u\ */
	gboolean vline;				/* TRUE:^uc\ */
	gint margin;				/* E}[W̐ */
	gint tab;					/* ^u̐ */
	GdkColor color[12];			/* F */
} FTYPE;
typedef struct doing {
	gint length;				/*  */
	gboolean caret;
	gchar *text;
	GdkPoint cursor,select;
	struct doing *next;
} DOING;
typedef struct linebuf {
	gboolean margin;			/* TRUE:E}[W,FALSE:ʏ̉s */
	gchar *text;
	gint length;				/*  */
	struct linebuf *prev,*next;
} LINEBUF;
typedef struct textwnd {
	gchar *file;				/* t@C */
	gchar *fontname;			/* tHg */
	gboolean create;			/* TRUE:VK쐬,FALSE:t@C */
	gboolean edit;				/* TRUE:ҏWς,FALSE:ҏW */
	gboolean code;				/* TRUE:^ũR[h\ */
	gboolean crlf;				/* TRUE:sR[h\ */
	gboolean eof;				/* TRUE:1Aht@C̖ɏ */
	gboolean limit;				/* TRUE:E}[WŐ܂Ԃ */
	gboolean overwrite;			/* TRUE:t@C㏑ƂɊmF */
	gboolean space;				/* TRUE:Xy[XDF̎lpŕ\ */
	gboolean gline;				/* TRUE:Obh\ */
	gboolean mline;				/* TRUE:E}[W\ */
	gboolean uline;				/* TRUE:^u\ */
	gboolean vline;				/* TRUE:^uc\ */
	gint fontsize;				/* tHg̉ */
	gint fontascent;			/* tHg̃ANZg̍ */
	gint margin;				/* E}[W̐ */
	gint max;					/* s */
	gint off;					/* startQƂs */
	gint same;					/* -1:dȂ,0`:ԍ */
	gint tab;					/* ^u̐ */
	guint timer_id;				/* XN[p^C} */
	DOING *undo,*redo;			/* ҏW */
	LINEBUF *start;				/* `Xg */
	GdkColor color[12];			/* F */
	GdkFont *font;				/* tHg */
	GdkIC *ic;					/* XIM */
	GdkICAttr *ic_attr;			/* XIM̑ */
	GdkPoint top;				/* EChE̐擪 */
	GdkPoint cursor;			/* Lbg̈ʒu */
	GdkPoint select;			/* IJnʒu,-1:IȂ */
	GtkWidget *drawing;			/* `̈ */
	GtkWidget *hscroll;			/* XN[o[ */
	GtkWidget *vscroll;			/* XN[o[ */
	GtkWidget *menu_item;		/* j[̃EChE̍ */
} TEXTWND;


enum {
	TARGET_STRING,
	TARGET_TEXT,
	TARGET_COMPOUND_TEXT
};


extern gboolean newfile;				/* TRUE:VKt@C,FALSE:Ȃ */
extern gboolean caret;					/* Lbǧ` */
extern gboolean ins;					/* TRUE:},FALSE:㏑ */
extern gboolean has_selection;			/* TRUE:L,FALSE:Ȃ */
extern gchar *clipboard_text;			/* Nbv{[h̃eLXg */
extern gchar *hisfile[10];				/* t@C̗ */
extern gint ftnum;						/* t@C^Cv̐ */
extern gint history;					/* t@C̗ */
extern gint def_width,def_height;		/* ftHg̃EChẼTCY */
extern guint timer_id;					/* ^C}ID */
extern FTYPE *ftype;					/* t@C^Cv */
extern GdkAtom clipboard_atom;			/* Nbv{[h */
extern GtkWidget *window;				/* EChE */
extern GtkWidget *notebook;				/* m[gubN */
extern GtkWidget *status;				/* Xe[^XEChE */
extern GtkItemFactory *item_factory;	/* j[ */


#endif
/*
\F
 0,
 1,wi
 2,Rg[R[h
 3,SpXy[X
 4,sR[h
 5,^u
 6,E}[W
 7,Obh
 8,Iꂽ
 9,Iꂽwi
10,()
11,Rg[R[h()
*/
