/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "other.h"
#include "repinfo.h"


/******************************************************************************
*                                                                             *
* ִ                                                        *
*                                                                             *
******************************************************************************/
static gint repinfo_clicked_button;
static GtkWidget *dialog;


/* ܥ󤬲줿 */
static void repinfo_dialog_clicked(GtkWidget *widget,gint button)
{
	gtk_widget_destroy(dialog);
	repinfo_clicked_button=button;
}


/* ESC줿 */
static gboolean repinfo_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


gint repinfo_dialog(REPINFO *ri)
{
	gchar *text;
	GtkAccelGroup *accel;
	GtkWidget *button0,*button1,*button2,*button3;
	GtkWidget *frame0,*frame1,*hbox,*tbox,*vbox;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),_("ִ"));
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
							GTK_SIGNAL_FUNC(repinfo_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* ܥ */
	button0=gtk_button_new_with_label(_("ִ"));
	button1=gtk_button_new_with_label(_(""));
	button2=gtk_button_new_with_label(_("٤ִ"));
	button3=gtk_button_new_with_label(_(""));
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",
										repinfo_dialog_clicked,(gpointer)1);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
										repinfo_dialog_clicked,(gpointer)0);
	gtk_signal_connect(GTK_OBJECT(button2),"clicked",
										repinfo_dialog_clicked,(gpointer)2);
	gtk_signal_connect_object(GTK_OBJECT(button3),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button2,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button3,GTK_CAN_DEFAULT);
	/* 졼 */
	accel=gtk_accel_group_new();
	gtk_accel_group_attach(accel,GTK_OBJECT(dialog));
	gtk_widget_add_accelerator(button0,"clicked",accel,'R',
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	set_label_pattern(GTK_BIN(button0)->child,'R');
	gtk_widget_add_accelerator(button1,"clicked",accel,'N',
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	set_label_pattern(GTK_BIN(button1)->child,'N');
	gtk_widget_add_accelerator(button2,"clicked",accel,'A',
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	set_label_pattern(GTK_BIN(button2)->child,'A');
	/* ե졼ȥܥå */
	tbox=gtk_vbox_new(FALSE,0);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),
								gtk_label_new(_("ʸ")),FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),gtk_label_new(ri->src),TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,FALSE,FALSE,8);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),
								gtk_label_new(_("ִʸ")),FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),gtk_label_new(ri->dst),TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,FALSE,FALSE,8);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),
								gtk_label_new(_("ִϰ")),FALSE,FALSE,8);
	text=g_strdup_printf(_("(%d,%d)-(%d,%d)"),
						ri->start.x+1,ri->start.y+1,ri->end.x+1,ri->end.y+1);
	gtk_box_pack_start(GTK_BOX(hbox),gtk_label_new(text),TRUE,TRUE,8);
	g_free(text);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,FALSE,FALSE,8);
	frame0=gtk_frame_new(_("ץ"));
	hbox=gtk_hbox_new(FALSE,0);
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),
						gtk_label_new(ri->ignorecase?_("/ʸ̤")
								:_("/ʸ̤ʤ")),FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,TRUE,TRUE,8);
	gtk_container_add(GTK_CONTAINER(frame0),hbox);
	frame1=gtk_frame_new(_("ִ"));
	hbox=gtk_hbox_new(FALSE,0);
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),
					gtk_label_new(ri->arrow?_(""):_("")),FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,TRUE,TRUE,8);
	gtk_container_add(GTK_CONTAINER(frame1),hbox);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),frame0,TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(hbox),frame1,TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,TRUE,TRUE,8);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button3,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button2,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(tbox),hbox,FALSE,FALSE,8);
	gtk_container_add(GTK_CONTAINER(dialog),tbox);

	/* ɽ */
	gtk_widget_grab_focus(button1);
	repinfo_clicked_button=-1;

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	return repinfo_clicked_button;
}
