/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "find.h"
#include "other.h"
#include "replace.h"


gboolean replace_arrow=TRUE;				/* ִ */
gboolean replace_ignorecase=FALSE;			/* ִ */
gchar *replace_text[32];					/* ִʸ */
gint replace_num=0;							/* ϿƤִʸ */


/******************************************************************************
*                                                                             *
* ִ                                                            *
*                                                                             *
******************************************************************************/
static gint replace_clicked_button;
static GtkWidget *dialog,*check,*combo0,*combo1,*radio1,*button0,*button1;


/* ִܥ󤬲줿 */
static void replace_dialog_clicked_ok(GtkWidget *widget,REPLACE *rp)
{
	rp->src=g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo0)->entry)));
	rp->dst=g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)));
	rp->ignorecase=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check));
	rp->arrow=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio1));
	gtk_widget_destroy(dialog);
	replace_clicked_button=1;
}


/* ٤ִܥ󤬲줿 */
static void replace_dialog_clicked_all(GtkWidget *widget,REPLACE *rp)
{
	rp->src=g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo0)->entry)));
	rp->dst=g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)));
	rp->ignorecase=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check));
	rp->arrow=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio1));
	gtk_widget_destroy(dialog);
	replace_clicked_button=2;
}


/* ȥ꡼ǥ꥿󤬲줿 */
static void replace_dialog_activate(GtkWidget *widget,REPLACE *rp)
{
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo0)->entry)))>0)
		replace_dialog_clicked_ok(widget,rp);
}


/* ȥ꡼ѹ줿 */
static void replace_dialog_changed(GtkWidget *widget,gpointer user_data)
{
	gtk_widget_set_sensitive(button0,
							strlen(gtk_entry_get_text(GTK_ENTRY(widget)))>0);
	gtk_widget_set_sensitive(button1,
							strlen(gtk_entry_get_text(GTK_ENTRY(widget)))>0);
}


/* ESC줿 */
static gboolean replace_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


gint replace_dialog(REPLACE *rp)
{
	gint i;
	GList *glist=NULL;
	GSList *group=NULL;
	GtkAccelGroup *accel;
	GtkWidget *radio0,*button2;
	GtkWidget *frame0,*frame1,*hbox,*tbox,*vbox;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),_("ִ"));
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
							GTK_SIGNAL_FUNC(replace_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* ܥ */
	button0=gtk_button_new_with_label(_("ִ"));
	button1=gtk_button_new_with_label(_("٤ִ"));
	button2=gtk_button_new_with_label(_(""));
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",
												replace_dialog_clicked_ok,rp);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
												replace_dialog_clicked_all,rp);
	gtk_signal_connect_object(GTK_OBJECT(button2),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button2,GTK_CAN_DEFAULT);
	/* åܥ */
	check=gtk_check_button_new_with_label(_("ʸ/ʸ̤"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),rp->ignorecase);
	/* ܥܥå */
	for (i=0;i<find_num;i++)
		glist=g_list_append(glist,find_text[i]);
	combo0=gtk_combo_new();
	if (find_num>0) {
		gtk_combo_set_popdown_strings(GTK_COMBO(combo0),glist);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo0)->entry),find_text[0]);
		gtk_editable_select_region(GTK_EDITABLE(GTK_COMBO(combo0)->entry),
																		0,-1);
	}
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(combo0)->entry),"activate",
												replace_dialog_activate,rp);
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(combo0)->entry),"changed",
												replace_dialog_changed,NULL);
	glist=NULL;
	for (i=0;i<replace_num;i++)
		glist=g_list_append(glist,replace_text[i]);
	combo1=gtk_combo_new();
	if (replace_num>0) {
		gtk_combo_set_popdown_strings(GTK_COMBO(combo1),glist);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo1)->entry),
															replace_text[0]);
	}
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(combo1)->entry),"activate",
												replace_dialog_activate,rp);
	/* 饸ܥ */
	radio0=gtk_radio_button_new_with_label(group,_(""));
	group=gtk_radio_button_group(GTK_RADIO_BUTTON(radio0));
	radio1=gtk_radio_button_new_with_label(group,_(""));
	group=gtk_radio_button_group(GTK_RADIO_BUTTON(radio1));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rp->arrow?radio1:radio0),
																		TRUE);
	/* 졼 */
	accel=gtk_accel_group_new();
	gtk_accel_group_attach(accel,GTK_OBJECT(dialog));
	gtk_widget_add_accelerator(check,"clicked",accel,'C',
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	set_label_pattern(GTK_BIN(check)->child,'C');
	gtk_widget_add_accelerator(radio0,"clicked",accel,'U',
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	set_label_pattern(GTK_BIN(radio0)->child,'U');
	gtk_widget_add_accelerator(radio1,"clicked",accel,'D',
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	set_label_pattern(GTK_BIN(radio1)->child,'D');
	gtk_widget_add_accelerator(button0,"clicked",accel,'R',
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	set_label_pattern(GTK_BIN(button0)->child,'R');
	gtk_widget_add_accelerator(button1,"clicked",accel,'A',
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	set_label_pattern(GTK_BIN(button1)->child,'A');
	/* ե졼ȥܥå */
	tbox=gtk_vbox_new(FALSE,0);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),
								gtk_label_new(_("ʸ")),FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),combo0,TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,FALSE,FALSE,8);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),
								gtk_label_new(_("ִʸ")),FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),combo1,TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,FALSE,FALSE,8);
	frame0=gtk_frame_new(_("ץ"));
	hbox=gtk_hbox_new(FALSE,0);
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),check,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,TRUE,TRUE,8);
	gtk_container_add(GTK_CONTAINER(frame0),hbox);
	frame1=gtk_frame_new(_("ִ"));
	hbox=gtk_hbox_new(FALSE,0);
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),radio0,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(vbox),radio1,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,TRUE,TRUE,8);
	gtk_container_add(GTK_CONTAINER(frame1),hbox);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),frame0,TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(hbox),frame1,TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,TRUE,TRUE,8);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button2,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(tbox),hbox,FALSE,FALSE,8);
	gtk_container_add(GTK_CONTAINER(dialog),tbox);

	/* ɽ */
	gtk_widget_set_sensitive(button0,
			strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo0)->entry)))>0);
	gtk_widget_set_sensitive(button1,
			strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo0)->entry)))>0);
	gtk_widget_grab_focus(GTK_COMBO(combo0)->entry);
	replace_clicked_button=-1;

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	return replace_clicked_button;
}
