/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "edit.h"
#include "general.h"
#include "jump.h"
#include "other.h"


/******************************************************************************
*                                                                             *
* ״ؿ                                                              *
*                                                                             *
******************************************************************************/
/*	Ԥذư
	 ptw,TXTɥ
	line,(1...)														*/
void jump_operation(TEXTWND *ptw,gint line)
{
	gint sx,sy;
	GdkPoint cursor,select,top;

	cursor=ptw->cursor;
	select=ptw->select;
	top=ptw->top;
	sx=MAX(ptw->drawing->allocation.width/ptw->fontwidth,1);
	sy=MAX(ptw->drawing->allocation.height/ptw->fontheight,1);
	ptw->cursor.y=line<0?ptw->max+line:line-1;
	if (ptw->cursor.y<0)
		ptw->cursor.y=0;
	else if (ptw->cursor.y>ptw->max-1)
		ptw->cursor.y=ptw->max-1;
	if (ptw->cursor.x<ptw->top.x)
		ptw->top.x=ptw->cursor.x;
	else if (ptw->cursor.x-sx+1>ptw->top.x)
		ptw->top.x=ptw->cursor.x-sx+1;
	if (ptw->cursor.y<ptw->top.y)
		ptw->top.y=ptw->cursor.y;
	else if (ptw->cursor.y-sy+1>ptw->top.y)
		ptw->top.y=ptw->cursor.y-sy+1;
	move_text_window(ptw,&top);
	if (ptw->select.x>=0) {
		if (ptw->select.y==ptw->cursor.y
									&& ptw->select.x==get_align_pos(ptw,
										ptw->cursor.x,ptw->cursor.y,FALSE)) {
			ptw->select.x=-1;
			clear_sel(ptw,&select,&cursor);
			set_menu_bar(ptw);
		} else {
			clear_sel(ptw,&ptw->cursor,&cursor);
		}
	}
	draw_caret(ptw,&cursor);
}


/******************************************************************************
*                                                                             *
* ץؿ                                                    *
*                                                                             *
******************************************************************************/
static gboolean jump_clicked_ok;
static GtkWidget *dialog,*button0,*entry;


/* OKܥ󤬲줿 */
static void jump_dialog_clicked(GtkWidget *widget,JMPDLG *jmp)
{
	strval(&jmp->cursor,gtk_entry_get_text(GTK_ENTRY(entry)),10,FALSE);
	gtk_widget_destroy(dialog);
	jump_clicked_ok=TRUE;
}


/* ȥ꡼ǥ꥿󤬲줿 */
static void jump_dialog_activate(GtkWidget *widget,JMPDLG *jmp)
{
	gint value;

	strval(&value,gtk_entry_get_text(GTK_ENTRY(widget)),10,FALSE);
	if (1<=value && value<=jmp->max)
		jump_dialog_clicked(widget,jmp);
}


/* ȥ꡼ѹ줿 */
static void jump_dialog_changed(GtkWidget *widget,JMPDLG *jmp)
{
	gint value;

	strval(&value,gtk_entry_get_text(GTK_ENTRY(widget)),10,FALSE);
	gtk_widget_set_sensitive(button0,1<=value && value<=jmp->max);
}


/* ESC줿 */
static gboolean jump_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


gboolean jump_dialog(JMPDLG *jmp)
{
	gchar *text;
	GtkWidget *button1,*hbox,*vbox;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),_("Ԥذư"));
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
								GTK_SIGNAL_FUNC(jump_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* ܥ */
	button0=gtk_button_new_with_label(_("λ"));
	button1=gtk_button_new_with_label(_(""));
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",jump_dialog_clicked,jmp);
	gtk_signal_connect_object(GTK_OBJECT(button1),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	/* ȥ꡼ */
	entry=gtk_entry_new();
	text=valstr(jmp->cursor,10,0,FALSE);
	gtk_entry_set_text(GTK_ENTRY(entry),text);
	g_free(text);
	gtk_signal_connect(GTK_OBJECT(entry),"activate",jump_dialog_activate,jmp);
	gtk_signal_connect(GTK_OBJECT(entry),"changed",jump_dialog_changed,jmp);
	gtk_editable_select_region(GTK_EDITABLE(entry),0,-1);
	/* ե졼ȥܥå */
	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	gtk_box_pack_start(GTK_BOX(vbox),entry,TRUE,TRUE,0);
	hbox=gtk_hbox_new(FALSE,7);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);

	/* ɽ */
	gtk_widget_set_sensitive(button0,FALSE);
	gtk_widget_grab_focus(entry);
	jump_clicked_ok=FALSE;

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	return jump_clicked_ok;
}
