/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __CHARSET_H__
#define __CHARSET_H__


#include "tmaid.h"


#define charset_length(ch) (charset->length[(gint)(guchar)(ch)])
#define charset_width(font,text,size) 										\
				(charset->length[(gint)*(guchar *)(text)]<=1?1				\
				:MAX((gdk_text_width((font),(text),							\
				charset->length[(gint)*(guchar *)(text)])+(size)-1)/(size),1))
#define charset_type(text,leng) (charset_length(*text)==(leng)				\
									?charset->type[(gint)(guchar)(*text)]:0)
#define CS_CONTROL		0x00000001
#define CS_SPACE		0x00000002
#define CS_PUNCT		0x00000004
#define CS_SYMBOL		0x00000008
#define CS_ACCENT		0x00000010
#define CS_DIGIT		0x00000020
#define CS_ALPHA		0x00000040
#define CS_KANA_ACCENT	0x00000100
#define CS_KANA			0x00000200
#define CS_M_SYMBOL 	0x00010000
#define CS_M_DIGITALPHA	0x00020000
#define CS_M_HIRAGANA	0x00040000
#define CS_M_KATAKANA	0x00080000
#define CS_M_GREEK		0x00100000
#define CS_M_CYRILLIC	0x00200000
#define CS_M_LINE		0x00400000
#define CS_M_MARK		0x00800000
#define CS_M_KANJI		0x01000000
#define CS_M_KANA		0x02000000
#define CS_M_HANGUL		0x04000000


typedef struct {
	gchar *name;
	gint length[256];
	guint32 type[256];
	guchar *space;
} CHARSET;


extern CHARSET *charset,charsetlist[];


void charset_set(gchar *lang);
void charset_init(void);
void charset_size(GdkFont *font,gint *width,gint *height,gint *ascent);


#endif
