/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "other.h"
#include "profile.h"


/******************************************************************************
*                                                                             *
* եؿ                                                        *
*                                                                             *
******************************************************************************/
/*	ե򳫤
	file,ե̾
	 RET,ץե														*/
PROFILE *profile_open(gchar *file)
{
	gchar *section,*data,buf[256];
	gint n;
	FILE *fp;
	PROFILE *profile;
	PROFILELIST *p,*q;

	if (file==NULL)
		return NULL;
	profile=g_malloc(sizeof(PROFILE));
	profile->edit=FALSE;
	profile->file=g_path_is_absolute(file)?g_strdup(file)
							:g_strdup_printf("%s/%s",g_get_home_dir(),file);
	/* ե뤫ɤ߹ */
	if ((fp=fopen(profile->file,"rt"))==NULL) {
		profile->list=NULL;
		return profile;
	}
	profile->list=p=g_malloc(sizeof(PROFILELIST));
	p->data=p->section=p->key=p->value=NULL;
	p->prev=p->next=NULL;
	while (fgets(buf,256,fp)!=NULL) {
		if (p->data==NULL) {
			p->data=g_strdup(buf);
		} else {
			data=g_strconcat(p->data,buf,NULL);
			g_free(p->data);
			p->data=data;
		}
		if (strlen(p->data)>0 && p->data[strlen(p->data)-1]=='\n') {
			p->data[strlen(p->data)-1]='\0';
			q=g_malloc(sizeof(PROFILELIST));
			q->data=q->section=q->key=q->value=NULL;
			q->prev=p;
			q->next=p->next;
			p->next=q;
			p=q;
		}
	}
	if (fclose(fp)!=0) {
		for (p=profile->list;p!=NULL;p=q) {
			q=p->next;
			g_free(p->data);
			g_free(p);
		}
		profile->list=NULL;
		return profile;
	}
	/* ꥹȤκǸ */
	if (p->data==NULL) {
		if (p->prev!=NULL)
			p->prev->next=NULL;
		else
			profile->list=NULL;
		g_free(p);
	}
	/* ꥹȤ */
	section=NULL;
	for (p=profile->list;p!=NULL;p=p->next) {
		data=p->data!=NULL?g_strstrip(g_strdup(p->data)):NULL;
		n=data!=NULL?strlen(data):0;
		if (n<=0) {
			p->type=PROFILE_DATA_TYPE_SPACE;
		} else if (data[0]=='#' || data[0]==';') {
			p->type=PROFILE_DATA_TYPE_COMMENT;
		} else if (data[0]=='[' && data[n-1]==']') {
			p->type=PROFILE_DATA_TYPE_SECTION;
			g_free(section);
			section=g_strdup(data+1);
			section[n-2]='\0';
			for (q=p->prev;q!=NULL;q=q->prev)
				if (q->type==PROFILE_DATA_TYPE_SPACE) {
					g_free(p->section);
					p->section=NULL;
				} else {
					break;
				}
		} else if (strchr(data,'=')!=NULL) {
			p->type=PROFILE_DATA_TYPE_KEY;
			p->key=g_strdup(data);
			*strchr(p->key,'=')='\0';
			p->value=strchr(p->data,'=')+1;
		} else {
			p->type=PROFILE_DATA_TYPE_UNKNOW;
		}
		p->section=g_strdup(section);
		g_free(data);
	}
	g_free(section);
	return profile;
}


/*	եĤ
	profile,ץե
	    RET,TRUE:ｪλ,FALSE:顼										*/
gboolean profile_close(PROFILE *profile)
{
	FILE *fp;
	PROFILELIST *p,*q;

	if (profile==NULL)
		return TRUE;
	if (profile->edit && (fp=fopen(profile->file,"wt"))!=NULL) {
		/* ѹäȤ */
		for (p=profile->list;p!=NULL;p=p->next) {
			if (p->data!=NULL)
				fputs(p->data,fp);
			fputc('\n',fp);
		}
		fclose(fp);
	}
	g_free(profile->file);
	for (p=profile->list;p!=NULL;p=q) {
		q=p->next;
		g_free(p->data);
		g_free(p->section);
		g_free(p->key);
		g_free(p);
	}
	g_free(profile);
	return TRUE;
}


/*	ե뤫ʸ
	profile,ץե
	section,
	    key,
	    RET,ʸ,NULL:顼												*/
gchar *profile_get_string(PROFILE *profile,gchar *section,gchar *key)
{
	PROFILELIST *p;

	if (section==NULL || key==NULL)
		return FALSE;
	for (p=profile->list;p!=NULL;p=p->next)
		if (p->type==PROFILE_DATA_TYPE_KEY
										&& g_strcasecmp(p->section,section)==0
										&& g_strcasecmp(p->key,key)==0)
			break;
	return p!=NULL?g_strdup(p->value):NULL;
}


/*	ե뤫ͤ
	profile,ץե
	section,
	    key,
	  value,ͤХåե
	   size,ͤХåեΥ
	   type,
	    RET,TRUE:ｪλ,FALSE:顼										*/
gboolean profile_get_value(PROFILE *profile,gchar *section,gchar *key,
										gpointer *value,gint size,guint type)
{
	guint8 s;
	gchar *endptr,*nptr;
	gint n;
	PROFILELIST *p;

	if (section==NULL || key==NULL || value==NULL)
		return FALSE;
	for (p=profile->list;p!=NULL;p=p->next)
		if (p->type==PROFILE_DATA_TYPE_KEY
										&& g_strcasecmp(p->section,section)==0
										&& g_strcasecmp(p->key,key)==0)
			break;
	if (p==NULL)
		return FALSE;
	switch (type) {
		case PROFILE_VALUE_TYPE_BOOL:
			if (size<sizeof(gboolean))
				return FALSE;
			if (g_strcasecmp(p->value,"true")==0)
				*((gboolean *)value)=TRUE;
			else if (g_strcasecmp(p->value,"false")==0)
				*((gboolean *)value)=FALSE;
			else
				return FALSE;
			break;
		case PROFILE_VALUE_TYPE_INT:
			if (size<sizeof(gint))
				return FALSE;
			strval((gint *)value,p->value,10,TRUE);
			break;
		case PROFILE_VALUE_TYPE_STRING:
			if (size<strlen(p->value)+1)
				return FALSE;
			strcpy((gchar *)value,p->value);
			break;
		case PROFILE_VALUE_TYPE_ARRAY:
			n=0;
			nptr=p->value;
			while (*nptr!='\0') {
				strtol(nptr,&endptr,0);
				if (nptr==endptr) {
					nptr++;
				} else {
					nptr=endptr;
					n++;
				}
			}
			if (size<n)
				return FALSE;
			n=0;
			nptr=p->value;
			while (*nptr!='\0') {
				s=strtol(nptr,&endptr,0);
				if (nptr==endptr) {
					nptr++;
				} else {
					nptr=endptr;
					((guint8 *)value)[n++]=s;
				}
			}
			break;
		default:
			return FALSE;
	}
	return TRUE;
}


/*	եͤꤹ
	profile,ץե
	section,
	    key,
	  value,ͤäƤХåե
	   size,ͤäƤХåեΥ
	   type,
	    RET,TRUE:ｪλ,FALSE:顼										*/
gboolean profile_set_value(PROFILE *profile,gchar *section,gchar *key,
										gpointer *value,gint size,guint type)
{
	gchar *data;
	gint i;
	PROFILELIST *p,*q=NULL;

	if (section==NULL || key==NULL || value==NULL)
		return FALSE;
	for (p=profile->list;p!=NULL;q=p,p=p->next)
		if (p->type==PROFILE_DATA_TYPE_KEY
										&& g_strcasecmp(p->section,section)==0
										&& g_strcasecmp(p->key,key)==0)
			break;
	if (p==NULL) {
		for (p=q;p!=NULL;p=p->prev)
			if (p->section!=NULL && g_strcasecmp(p->section,section)==0)
				break;
		if (p==NULL) {
			if (q!=NULL) {
				/* ΥǡȤδ֤˥ڡ */
				p=g_malloc(sizeof(PROFILELIST));
				p->type=PROFILE_DATA_TYPE_SPACE;
				p->data=p->section=p->key=p->value=NULL;
				p->prev=q;
				p->next=q->next;
				q->next=p;
				q=p;
			}
			/* ⥭ʤȤˤϥ */
			p=g_malloc(sizeof(PROFILELIST));
			p->type=PROFILE_DATA_TYPE_SECTION;
			p->data=g_strdup_printf("[%s]",section);
			p->section=g_strdup(section);
			p->key=p->value=NULL;
			p->prev=q;
			if (q!=NULL) {
				p->next=q->next;
				q->next=p;
			} else {
				p->next=NULL;
				profile->list=p;
			}
		}
		q=p;
		while (q->type==PROFILE_DATA_TYPE_SPACE && q->section!=NULL
					&& g_strcasecmp(p->section,section)==0 && q->prev!=NULL)
			q=q->prev;
		/* κǸ˥ */
		p=g_malloc(sizeof(PROFILELIST));
		p->type=PROFILE_DATA_TYPE_KEY;
		p->data=g_strdup_printf("%s=",key);
		p->section=g_strdup(section);
		p->key=g_strdup(key);
		p->value=strchr(p->data,'=')+1;
		p->prev=q;
		p->next=q->next;
		q->next=p;
		if (p->next!=NULL)
			p->next->prev=p;
	}
	switch (type) {
		case PROFILE_VALUE_TYPE_BOOL:
			g_free(p->data);
			p->data=g_strdup_printf("%s=%s",
								p->key,*((gboolean *)value)?"true":"false");
			break;
		case PROFILE_VALUE_TYPE_INT:
			g_free(p->data);
			p->data=g_strdup_printf("%s=%d",p->key,*((gint *)value));
			break;
		case PROFILE_VALUE_TYPE_STRING:
			g_free(p->data);
			p->data=g_strdup_printf("%s=%s",p->key,(gchar *)value);
			break;
		case PROFILE_VALUE_TYPE_ARRAY:
			g_free(p->data);
			p->data=g_strdup_printf("%s=%u",p->key,((guint8 *)value)[0]);
			for (i=1;i<size;i++) {
				data=g_strdup_printf("%s %u",p->data,((guint8 *)value)[i]);
				g_free(p->data);
				p->data=data;
			}
			break;
		default:
			return FALSE;
	}
	p->value=strchr(p->data,'=')+1;
	profile->edit=TRUE;
	return TRUE;
}


/*	եΥ
	profile,ץե
	section,
	    RET,TRUE:ｪλ,FALSE:顼										*/
gboolean profile_delete_section(PROFILE *profile,gchar *section)
{
	gboolean result=FALSE;
	PROFILELIST *p,*q;

	if (section==NULL)
		return FALSE;
	for (p=profile->list;p!=NULL;p=q) {
		q=p->next;
		if (p->section!=NULL && g_strcasecmp(p->section,section)==0) {
			if (p->prev!=NULL)
				p->prev->next=p->next;
			if (p->next!=NULL)
				p->next->prev=p->prev;
			g_free(p->data);
			g_free(p->section);
			g_free(p->key);
			g_free(p);
			result=TRUE;
		}
	}
	return result;
}
