/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "jump.h"
#include <commctrl.h>
#include "edit.h"
#include "general.h"
#include "resource.h"
#include "wcommon.h"


/******************************************************************************
*                                                                             *
* ジャンプ関数群                                                              *
*                                                                             *
******************************************************************************/
/*  ja:指定行へ移動
     hWnd,ウインドウ
    nLine,新しい行(1...)                                                    */
VOID
JumpOperation (HWND hWnd,
               int  nLine)
{
  int sx, sy;
  POINT ptCursor, ptTop;
  LPTEXTWND ptw;

  ptw = (LPTEXTWND)GetWindowLongPtr (hWnd, GWLP_USERDATA);
  ptCursor = ptw->ptCursor;
  ptTop = ptw->ptTop;
  sx = max (ptw->siWnd.cx / ptw->nFontSize, 1);
  sy = max (ptw->siWnd.cy / (ptw->nFontSize * 2), 1);
  ptw->ptCursor.y = nLine < 0 ? ptw->nMax + nLine : nLine - 1;
  if (ptw->ptCursor.x < ptw->ptTop.x)
    ptw->ptTop.x = ptw->ptCursor.x;
  else if (ptw->ptCursor.x - sx + 1 > ptw->ptTop.x)
    ptw->ptTop.x = ptw->ptCursor.x - sx + 1;
  if (ptw->ptCursor.y < ptw->ptTop.y)
    ptw->ptTop.y = ptw->ptCursor.y;
  else if (ptw->ptCursor.y - sy + 1 > ptw->ptTop.y)
    ptw->ptTop.y = ptw->ptCursor.y - sy + 1;
  HideCaret (hWnd);
  if (ptw->ptSelect.x >= 0)
    {
      if (ptw->ptSelect.y == ptw->ptCursor.y
                            && ptw->ptSelect.x == GetAlignPos (&ptw->lpStart,
                                &ptw->nOff, ptw->ptCursor.x, ptw->ptCursor.y,
                                                            ptw->nTab, FALSE))
        {
          ClearSel (hWnd, &ptw->ptSelect, &ptCursor);
          ptw->ptSelect.x = -1;
          SetMenuBar (ptw);
        }
      else
        {
          ClearSel (hWnd, &ptw->ptCursor, &ptCursor);
        }
    }
  DrawCaret (hWnd);
  MoveTextWindow (hWnd, &ptTop);
  ShowCaret (hWnd);
}


/******************************************************************************
*                                                                             *
* ja:ジャンプダイアログ関数群                                                 *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
JumpDlgProc (HWND   hDlg,
             UINT   uMsg,
             WPARAM wParam,
             LPARAM lParam)
{
  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          LPJUMPDLG lpDlg;

          SetWindowLongPtr (hDlg, DWLP_USER, lParam);
          lpDlg = (LPJUMPDLG)lParam;
          /* ja:エディトコントロールの設定 */
          SetDlgItemInt (hDlg, IDC_EDIT71, lpDlg->nCursor, TRUE);
          /* ja:アップダウンコントロールの設定 */
          UpDownItem_SetRange (hDlg, IDC_UPDOWN71, 1, lpDlg->nMax);
          /* ja:コントロールの表示状態 */
          EnableDlgItem (hDlg, IDOK, FALSE);
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              {
                LPJUMPDLG lpDlg;

                lpDlg = (LPJUMPDLG)GetWindowLongPtr (hDlg, DWLP_USER);
                lpDlg->nCursor = GetDlgItemInt (hDlg, IDC_EDIT71, NULL, TRUE);
              }
            case IDCANCEL:
              EndDialog (hDlg, LOWORD (wParam));
              break;
            case IDC_EDIT71:
              if (HIWORD (wParam) == EN_CHANGE)
                {
                  LPJUMPDLG lpDlg;

                  lpDlg = (LPJUMPDLG)GetWindowLongPtr (hDlg, DWLP_USER);
                  /* ja:コントロールの表示状態 */
                  if (lpDlg)
                    {
                      int nValue;

                      nValue = GetDlgItemInt (hDlg, IDC_EDIT71, NULL, TRUE);
                      EnableDlgItem (hDlg, IDOK,
                                        1 <= nValue && nValue <= lpDlg->nMax);
                    }
                }
          }
        return TRUE;
    }
  return FALSE;
}
