/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WIME_H__
#define __WIME_H__


#include <windows.h>


#ifdef __cplusplus
extern "C" {
#endif


/******************************************************************************
*                                                                             *
* ja:IME制御関数                                                              *
*                                                                             *
******************************************************************************/
/*  ja:IMEを初期化する                                                      */
VOID
InitIme (VOID);


/*  ja:IMEを終了する                                                        */
VOID
ExitIme (VOID);


/*  ja:IMEの位置を設定する
    hWnd,ウインドウ
       x,x座標
       y,y座標
     RET,TRUE:正常終了,FALSE:エラー                                         */
BOOL
SetImePos (HWND      hWnd,
           const int x,
           const int y);


/*  ja:IMEのフォントを設定する
         hWnd,ウインドウ
    lpLogFont,フォント情報
          RET,TRUE:正常終了,FALSE:エラー                                    */
BOOL
SetImeFontW (HWND       hWnd,
             LPLOGFONTW lpLogFont);


/*  ja:IMEのフォントを設定する
         hWnd,ウインドウ
    lpLogFont,フォント情報
          RET,TRUE:正常終了,FALSE:エラー                                    */
BOOL
SetImeFontA (HWND       hWnd,
             LPLOGFONTA lpLogFont);


#ifdef UNICODE
# define SetImeFont SetImeFontW
#else /* not UNICODE */
# define SetImeFont SetImeFontA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WIME_H__ */
