/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.dialog.TableEditDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.VirtualEntity;
import jp.sourceforge.tmdmaker.model.command.ImplementDerivationModelsDeleteCommand;
import jp.sourceforge.tmdmaker.model.command.ModelEditCommand;
import jp.sourceforge.tmdmaker.model.command.TableDeleteCommand;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class VirtualEntityEditPart
extends AbstractEntityEditPart {
    @Override
    protected void onDoubleClicked() {
        AbstractEntityModel entity = (AbstractEntityModel)this.getModel();
        TableEditDialog dialog = new TableEditDialog(this.getViewer().getControl().getShell(), "\u307f\u306a\u3057\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u7de8\u96c6", entity);
        if (dialog.open() == 0) {
            CompoundCommand ccommand = new CompoundCommand();
            List<EditAttribute> editAttributeList = dialog.getEditAttributeList();
            this.addAttributeEditCommands(ccommand, entity, editAttributeList);
            AbstractEntityModel edited = dialog.getEditedValue();
            ModelEditCommand command = new ModelEditCommand(entity, edited);
            if (entity.isNotImplement() && !edited.isNotImplement()) {
                AbstractEntityModel original = ImplementRule.findOriginalImplementModel(entity);
                ccommand.add((Command)new ImplementDerivationModelsDeleteCommand(entity, original));
            }
            ccommand.add((Command)command);
            this.getViewer().getEditDomain().getCommandStack().execute((Command)ccommand);
        }
    }

    @Override
    protected void updateFigure(IFigure figure) {
        EntityFigure entityFigure = (EntityFigure)figure;
        AbstractEntityModel entity = (AbstractEntityModel)this.getModel();
        entityFigure.setNotImplement(entity.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(entity.getName());
        entityFigure.setEntityType(EntityType.VE.getLabel());
        for (Map.Entry<AbstractEntityModel, ReusedIdentifier> rk : entity.getReusedIdentifieres().entrySet()) {
            for (Identifier identifier : rk.getValue().getIdentifires()) {
                entityFigure.addRelationship(identifier.getName());
            }
        }
    }

    protected IFigure createFigure() {
        EntityFigure figure = new EntityFigure();
        this.updateFigure((IFigure)figure);
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new VirtualEntityComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
    }

    public IFigure getContentPane() {
        return ((EntityFigure)this.getFigure()).getAttributeCompartmentFigure();
    }

    protected List getModelChildren() {
        return ((AbstractEntityModel)this.getModel()).getAttributes();
    }

    private static class VirtualEntityComponentEditPolicy
    extends ComponentEditPolicy {
        private VirtualEntityComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            VirtualEntity model = (VirtualEntity)this.getHost().getModel();
            CompoundCommand ccommand = new CompoundCommand();
            if (model.isNotImplement()) {
                AbstractEntityModel original = ImplementRule.findOriginalImplementModel(model);
                ccommand.add((Command)new ImplementDerivationModelsDeleteCommand(model, original));
            }
            ccommand.add((Command)new TableDeleteCommand(model, model.getModelTargetConnections().get(0)));
            return ccommand;
        }
    }
}

