/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.sourceforge.tmdmaker.model.KeyModel;
import jp.sourceforge.tmdmaker.model.SarogateKey;

public class KeyModels
implements Iterable<KeyModel> {
    private List<KeyModel> keys = new ArrayList<KeyModel>();
    private KeyModel masterKey;
    private SarogateKey sarogateKey;

    public KeyModel getMasterKey() {
        return this.masterKey;
    }

    public void add(KeyModel keyModel) {
        if (keyModel.isMasterKey()) {
            this.add(0, keyModel);
        } else {
            this.keys.add(keyModel);
        }
    }

    private void add(int index, KeyModel keyModel) {
        if (keyModel.isMasterKey()) {
            this.setMasterKey(keyModel);
            this.keys.add(0, keyModel);
        } else {
            this.keys.add(index, keyModel);
        }
    }

    private void setMasterKey(KeyModel keyModel) {
        if (this.masterKey != null) {
            this.masterKey.setMasterKey(false);
        }
        this.masterKey = keyModel;
    }

    public void replaceKeyModel(int index, KeyModel keyModel) {
        this.remove(index);
        this.add(index, keyModel);
    }

    public void remove(int index) {
        KeyModel model = this.keys.get(index);
        if (model == null) {
            return;
        }
        if (model.isMasterKey()) {
            this.setMasterKey(null);
        }
        this.keys.remove(index);
    }

    public void remove(KeyModel model) {
        if (model.isMasterKey()) {
            this.setMasterKey(null);
        }
        this.keys.remove(model);
    }

    public KeyModel get(int index) {
        return this.keys.get(index);
    }

    public int size() {
        return this.keys.size();
    }

    @Override
    public Iterator<KeyModel> iterator() {
        return new KeyModelIterator(this.keys);
    }

    public SarogateKey getSarogateKey() {
        if (this.sarogateKey == null) {
            this.sarogateKey = new SarogateKey();
        }
        return this.sarogateKey;
    }

    protected void setSarogateKey(SarogateKey sarogateKey) {
        this.sarogateKey = sarogateKey;
    }

    public void copyTo(KeyModels to) {
        to.setSarogateKey(this.getSarogateKey());
        for (KeyModel k : this) {
            to.add(k.getCopy());
        }
    }

    static class KeyModelIterator
    implements Iterator<KeyModel> {
        private List<KeyModel> keyModelList;
        private int index = 0;

        public KeyModelIterator(List<KeyModel> keyModelList) {
            this.keyModelList = keyModelList;
        }

        @Override
        public boolean hasNext() {
            return this.keyModelList.size() > this.index;
        }

        @Override
        public KeyModel next() {
            return this.keyModelList.get(this.index++);
        }

        @Override
        public void remove() {
            this.keyModelList.remove(this.index);
        }
    }
}

