/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.AbstractRelationship;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.RecursiveTable;
import org.eclipse.draw2d.geometry.Rectangle;

public class RecursiveRelationship
extends AbstractRelationship {
    private RecursiveTable table;
    private Diagram diagram;

    public RecursiveRelationship(AbstractEntityModel source) {
        this.setSource(source);
        this.table = new RecursiveTable();
        Rectangle constraint = source.getConstraint().getTranslated(100, 0);
        this.table.setConstraint(constraint);
        this.setTarget(this.table);
        this.diagram = this.getSource().getDiagram();
        this.table.setEntityType(source.getEntityType());
        this.table.setConstraint(source.getConstraint().getTranslated(100, 0));
        this.table.setName(String.valueOf(source.getName()) + "." + source.getName() + "." + "\u518d\u5e30\u8868");
        this.table.addCreationIdentifier(source);
    }

    @Override
    public void setTarget(AbstractEntityModel target) {
        super.setTarget(target);
    }

    @Override
    public void connect() {
        this.diagram.addChild(this.table);
        AbstractEntityModel sourceEntity = this.getSource();
        if (!sourceEntity.getModelSourceConnections().contains(this)) {
            sourceEntity.addSourceConnection(this);
        }
        this.table.addTargetConnection(this);
        this.attachSource();
        this.attachTarget();
    }

    @Override
    public void disconnect() {
        this.getSource().removeSourceConnection(this);
        this.table.removeTargetConnection(this);
        this.diagram.removeChild(this.table);
    }

    @Override
    public boolean isDeletable() {
        return this.table.isDeletable();
    }

    @Override
    public void identifierChanged() {
        this.table.fireIdentifierChanged(this);
    }
}

