/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

class ConfigurationCache {
    private final String extensionPointId;
    private final String parentTagName;
    private final String configTagName;
    private static Map configMap = null;
    private static Map parentMap = null;

    public ConfigurationCache(String extensionPointId, String parentTagName, String configTagName) {
        this.extensionPointId = extensionPointId;
        this.parentTagName = parentTagName;
        this.configTagName = configTagName;
    }

    public IConfigurationElement getElement(String id) {
        this.readConfigurations();
        return (IConfigurationElement)configMap.get(id);
    }

    public IConfigurationElement getParent(IConfigurationElement element) {
        this.readConfigurations();
        return (IConfigurationElement)parentMap.get(element);
    }

    private void readConfigurations() {
        if (configMap != null) {
            return;
        }
        configMap = new HashMap(100);
        parentMap = new HashMap(100);
        IConfigurationElement[] actionGroupElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPointId);
        int i = 0;
        while (i < actionGroupElements.length) {
            IConfigurationElement actionGroupElement = actionGroupElements[i];
            if (actionGroupElement.getName().equals(this.parentTagName)) {
                IConfigurationElement[] actionElements = actionGroupElement.getChildren();
                int j = 0;
                while (j < actionElements.length) {
                    IConfigurationElement actionElement = actionElements[j];
                    if (actionElement.getName().equals(this.configTagName)) {
                        configMap.put(actionElement.getAttribute("id"), actionElement);
                        parentMap.put(actionElement, actionGroupElement);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

