/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.actions.ConfigurationCache;
import org.eclipse.ui.actions.IObjectAction;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.ObjectActionContributor;
import org.eclipse.ui.internal.ObjectPluginAction;

class ObjectActionAdapter
implements IObjectAction {
    private static final ConfigurationCache configCache = new ConfigurationCache("org.eclipse.ui.popupMenus", "objectContribution", "action");
    private final String actionId;
    private final IConfigurationElement configuration;
    private ActionDescriptor descriptor;
    private ObjectPluginAction objAction;

    public static ObjectActionAdapter adapterForActionWithId(String id) {
        IConfigurationElement configuration = configCache.getElement(id);
        if (configuration == null) {
            return null;
        }
        return new ObjectActionAdapter(id, configuration);
    }

    private ObjectActionAdapter(String actionId, IConfigurationElement configuration) {
        this.actionId = actionId;
        this.configuration = configuration;
    }

    public void setActivePart(IWorkbenchPart targetPart) {
        this.getObjAction().setActivePart(targetPart);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.getObjAction().addPropertyChangeListener(listener);
    }

    public int getAccelerator() {
        return this.getObjAction().getAccelerator();
    }

    public String getActionDefinitionId() {
        return this.actionId;
    }

    public String getDescription() {
        return this.getObjAction().getDescription();
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return this.getObjAction().getDisabledImageDescriptor();
    }

    public HelpListener getHelpListener() {
        return this.getObjAction().getHelpListener();
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return this.getObjAction().getHoverImageDescriptor();
    }

    public String getId() {
        return this.getObjAction().getId();
    }

    public ImageDescriptor getImageDescriptor() {
        return this.getObjAction().getImageDescriptor();
    }

    public IMenuCreator getMenuCreator() {
        return this.getObjAction().getMenuCreator();
    }

    public int getStyle() {
        return this.getObjAction().getStyle();
    }

    public String getText() {
        return this.getObjAction().getText();
    }

    public String getToolTipText() {
        return this.getObjAction().getToolTipText();
    }

    public boolean isApplicableTo(IStructuredSelection selection) {
        if (!new SelectionEnabler(this.configuration).isEnabledForSelection((ISelection)selection)) {
            return false;
        }
        IConfigurationElement parentConfiguration = configCache.getParent(this.configuration);
        if (parentConfiguration == null) {
            return false;
        }
        ObjectActionContributor contributor = new ObjectActionContributor(parentConfiguration);
        Iterator elements = selection.iterator();
        while (elements.hasNext()) {
            Object obj = elements.next();
            if (contributor.isApplicableTo(obj)) continue;
            return false;
        }
        return true;
    }

    public boolean isChecked() {
        return this.getObjAction().isChecked();
    }

    public boolean isEnabled() {
        return this.getObjAction().isEnabled();
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.getObjAction().removePropertyChangeListener(listener);
    }

    public void run() {
        this.getObjAction().run();
    }

    public void runWithEvent(Event event) {
        this.getObjAction().runWithEvent(event);
    }

    public void setActionDefinitionId(String id) {
        this.getObjAction().setActionDefinitionId(id);
    }

    public void setChecked(boolean checked) {
        this.getObjAction().setChecked(checked);
    }

    public void setDescription(String text) {
        this.getObjAction().setDescription(text);
    }

    public void setDisabledImageDescriptor(ImageDescriptor newImage) {
        this.getObjAction().setDisabledImageDescriptor(newImage);
    }

    public void setEnabled(boolean enabled) {
        this.getObjAction().setEnabled(enabled);
    }

    public void setHelpListener(HelpListener listener) {
        this.getObjAction().setHelpListener(listener);
    }

    public void setHoverImageDescriptor(ImageDescriptor newImage) {
        this.getObjAction().setHoverImageDescriptor(newImage);
    }

    public void setId(String id) {
        this.getObjAction().setId(id);
    }

    public void setImageDescriptor(ImageDescriptor newImage) {
        this.getObjAction().setImageDescriptor(newImage);
    }

    public void setMenuCreator(IMenuCreator creator) {
        this.getObjAction().setMenuCreator(creator);
    }

    public void setText(String text) {
        this.getObjAction().setText(text);
    }

    public void setToolTipText(String text) {
        this.getObjAction().setToolTipText(text);
    }

    public void setAccelerator(int keycode) {
        this.getObjAction().setAccelerator(keycode);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.getObjAction().selectionChanged(part, selection);
    }

    private ObjectPluginAction getObjAction() {
        if (this.objAction == null) {
            this.objAction = (ObjectPluginAction)this.getActionDescriptor().getAction();
        }
        return this.objAction;
    }

    private ActionDescriptor getActionDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new ActionDescriptor(this.configuration, 1);
        }
        return this.descriptor;
    }

    public boolean isHandled() {
        return this.getObjAction().isHandled();
    }
}

