/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.dialog.CombinationTableEditDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.TMDModelGraphicalNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.CombinationTable;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.RecursiveTable;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.command.ModelEditCommand;
import jp.sourceforge.tmdmaker.model.command.TableDeleteCommand;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class CombinationTableEditPart
extends AbstractEntityEditPart {
    @Override
    protected void updateFigure(IFigure figure) {
        logger.debug(this.getClass() + "#updateFigure()");
        EntityFigure entityFigure = (EntityFigure)figure;
        CombinationTable table = (CombinationTable)this.getModel();
        entityFigure.setEntityType(table.getCombinationTableType().getLabel());
        entityFigure.setNotImplement(table.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(table.getName());
        ArrayList<String> reusedIdentifierNames = new ArrayList<String>();
        for (Map.Entry<AbstractEntityModel, ReusedIdentifier> rk : table.getReusedIdentifieres().entrySet()) {
            for (Identifier identifier : rk.getValue().getIdentifires()) {
                if (reusedIdentifierNames.contains(identifier.getName()) && !(rk.getKey() instanceof RecursiveTable)) continue;
                reusedIdentifierNames.add(identifier.getName());
            }
        }
        for (String name : reusedIdentifierNames) {
            entityFigure.addRelationship(name);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new CombinationTableComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TMDModelGraphicalNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
    }

    @Override
    protected void onDoubleClicked() {
        logger.debug(this.getClass() + "#onDoubleClicked()");
        CombinationTable table = (CombinationTable)this.getModel();
        CombinationTableEditDialog dialog = new CombinationTableEditDialog(this.getViewer().getControl().getShell(), "\u5bfe\u7167\u8868\u7de8\u96c6", table);
        if (dialog.open() == 0) {
            CompoundCommand ccommand = new CompoundCommand();
            List<EditAttribute> editAttributeList = dialog.getEditAttributeList();
            this.addAttributeEditCommands(ccommand, table, editAttributeList);
            ModelEditCommand command = new ModelEditCommand(table, dialog.getEditedValue());
            ccommand.add((Command)command);
            this.getViewer().getEditDomain().getCommandStack().execute(ccommand.unwrap());
        }
    }

    private static class CombinationTableComponentEditPolicy
    extends ComponentEditPolicy {
        private CombinationTableComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            CombinationTable model = (CombinationTable)this.getHost().getModel();
            AbstractConnectionModel creationRelationship = (AbstractConnectionModel)model.findCreationRelationship().getSource();
            return new TableDeleteCommand(model, creationRelationship);
        }
    }
}

