/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model.rule;

import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.Laputa;
import jp.sourceforge.tmdmaker.model.rule.EntityTypeRule;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;

public class EntityRecognitionRule {
    public static String generateEntityNameFromIdentifier(String identifierName) {
        String entityName = EntityRecognitionRule.removeIdentifierSuffixFromIdentifierName(identifierName);
        return EntityRecognitionRule.removeReportNameSuffixFromEntityName(entityName);
    }

    private static String removeIdentifierSuffixFromIdentifierName(String identifierName) {
        String[] suffixes;
        String[] stringArray = suffixes = new String[]{"\u30b3\u30fc\u30c9", "ID", "\uff29\uff24", "id", "\uff49\uff44", "\u756a\u53f7", "No"};
        int n = suffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            if (identifierName.endsWith(suffix)) {
                return identifierName.substring(0, identifierName.lastIndexOf(suffix));
            }
            ++n2;
        }
        return identifierName;
    }

    private static String removeReportNameSuffixFromEntityName(String entityName) {
        String[] reportSuffixes;
        String[] stringArray = reportSuffixes = new String[]{"\u4f1d\u7968", "\u5831\u544a\u66f8", "\u66f8", "\u30ec\u30dd\u30fc\u30c8"};
        int n = reportSuffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String reportSuffix = stringArray[n2];
            if (entityName.endsWith(reportSuffix)) {
                return entityName.substring(0, entityName.lastIndexOf(reportSuffix));
            }
            ++n2;
        }
        return entityName;
    }

    public static Entity createEntity(String entityName, Identifier identifier, EntityType entityType) {
        Entity entity = new Entity();
        entity.setName(entityName);
        entity.setEntityType(entityType);
        entity.setIdentifier(identifier);
        EntityTypeRule.addDefaultAttribute(entity);
        ImplementRule.setModelDefaultValue(entity);
        ImplementRule.setIdentifierDefaultValue(entity.getIdentifier());
        return entity;
    }

    public static Laputa createLaputa(String entityName, Identifier identifier) {
        Laputa laputa = new Laputa();
        if (entityName != null && entityName.length() > 0) {
            laputa.setName(entityName);
        } else {
            laputa.setName("\u30e9\u30d4\u30e5\u30bf");
        }
        if (identifier != null) {
            laputa.setIdentifier(identifier);
        } else {
            laputa.setIdentifier(new Identifier(entityName));
        }
        laputa.setEntityType(EntityType.LAPUTA);
        return laputa;
    }
}

