/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.tool;

import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.command.ModelConstraintChangeCommand;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.swt.events.KeyEvent;

public class MovableSelectionTool
extends SelectionTool {
    protected boolean handleKeyDown(KeyEvent e) {
        Point p = this.calcMovePoint(e.keyCode);
        if (this.hasMoved(p)) {
            this.doMove(p);
        }
        return super.handleKeyDown(e);
    }

    private Point calcMovePoint(int keyCode) {
        Point p = new Point(0, 0);
        switch (keyCode) {
            case 0x1000002: {
                p.y = 1;
                break;
            }
            case 0x1000003: {
                p.x = -1;
                break;
            }
            case 0x1000004: {
                p.x = 1;
                break;
            }
            case 0x1000001: {
                p.y = -1;
            }
        }
        return p;
    }

    private void doMove(Point p) {
        CompoundCommand command = new CompoundCommand();
        for (Object selection : this.getCurrentViewer().getSelectedEditParts()) {
            if (!(selection instanceof AbstractEntityEditPart)) continue;
            AbstractEntityEditPart part = (AbstractEntityEditPart)selection;
            command.add((Command)new ModelConstraintChangeCommand((ModelElement)part.getModel(), p.x, p.y));
        }
        if (!command.isEmpty()) {
            this.executeCommand(command.unwrap());
        }
    }

    private boolean hasMoved(Point p) {
        return p.x != 0 || p.y != 0;
    }
}

