/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.VirtualSuperset;
import jp.sourceforge.tmdmaker.model.rule.EntityRecognitionRule;
import jp.sourceforge.tmdmaker.model.rule.VirtualEntityRule;

public class Diagram
extends ModelElement {
    private String version;
    private String databaseName;
    private List<ModelElement> children = new ArrayList<ModelElement>();
    public static final String PROPERTY_CHILDREN = "_property_children";
    private List<IAttribute> commonAttributes = new ArrayList<IAttribute>();

    public void addChild(AbstractEntityModel child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
            child.setDiagram(this);
            this.firePropertyChange(PROPERTY_CHILDREN, null, child);
        }
    }

    public void addChild(ConnectableElement child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
            this.firePropertyChange(PROPERTY_CHILDREN, null, child);
        }
    }

    public void removeChild(AbstractEntityModel child) {
        child.setDiagram(null);
        this.children.remove(child);
        this.firePropertyChange(PROPERTY_CHILDREN, child, null);
    }

    public void removeChild(ConnectableElement child) {
        this.children.remove(child);
        this.firePropertyChange(PROPERTY_CHILDREN, child, null);
    }

    public List<ModelElement> getChildren() {
        return this.children;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<AbstractEntityModel> findEntityModel() {
        ArrayList<AbstractEntityModel> entities = new ArrayList<AbstractEntityModel>(this.getChildren().size());
        for (ModelElement m : this.getChildren()) {
            if (!(m instanceof AbstractEntityModel)) continue;
            entities.add((AbstractEntityModel)m);
        }
        return entities;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public List<IAttribute> getCommonAttributes() {
        return this.commonAttributes;
    }

    public void setCommonAttributes(List<IAttribute> commonAttributes) {
        this.commonAttributes = commonAttributes;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public Entity createEntity(String entityName, String identifierName, EntityType entityType) {
        Entity e = EntityRecognitionRule.getInstance().createEntity(entityName, new Identifier(identifierName), entityType);
        this.addChild(e);
        return e;
    }

    public VirtualSuperset createVirtualSuperset(String virtualSupersetName, List<AbstractEntityModel> virtualSubsets) {
        VirtualSuperset superset = VirtualEntityRule.createVirtualSuperset(virtualSupersetName);
        this.addChild(superset);
        for (AbstractEntityModel m : virtualSubsets) {
            superset.connectSubset(m);
        }
        return superset;
    }

    public List<AbstractEntityModel> findEntityModelExcludeFor(List<AbstractEntityModel> excludes) {
        ArrayList<AbstractEntityModel> list = new ArrayList<AbstractEntityModel>();
        for (ModelElement m : this.getChildren()) {
            if (!(m instanceof AbstractEntityModel) || excludes.contains(m)) continue;
            list.add((AbstractEntityModel)m);
        }
        return list;
    }
}

