/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model.rule;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Constraint;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;

public class SubsetRule {
    public static final int CHAR_SIZE = 12;

    public static SubsetType setupSubsetType(AbstractEntityModel model) {
        SubsetType subsetType = model.findSubsetType();
        if (subsetType == null) {
            subsetType = new SubsetType();
            subsetType.setSubsetType(SubsetType.SubsetTypeValue.SAME);
            subsetType.setExceptNull(false);
            subsetType.setConstraint(SubsetRule.calculateSubsetTypePosition(model));
        }
        return subsetType;
    }

    private static Constraint calculateSubsetTypePosition(AbstractEntityModel model) {
        int rx = model.calcurateMaxIdentifierRefSize();
        int ax = model.calcurateMaxAttributeNameSize();
        int x = (rx + ax) * 12 / 2;
        int identifierCount = model.getReusedIdentifiers().size();
        if (model instanceof Entity) {
            ++identifierCount;
        }
        int attributeCount = model.getAttributes().size();
        int acount = Math.max(identifierCount, attributeCount);
        int y = 70 + 12 * acount;
        Constraint constraint = model.getConstraint().getTranslated(x, y);
        return constraint;
    }

    public static SubsetEntity createSubsetEntity(AbstractEntityModel model, String subsetEntityName) {
        SubsetEntity subsetEntity = new SubsetEntity();
        subsetEntity.setName(subsetEntityName);
        subsetEntity.setOriginalReusedIdentifier(model.createReusedIdentifier());
        subsetEntity.setEntityType(model.getEntityType());
        ImplementRule.setModelDefaultValue(subsetEntity);
        return subsetEntity;
    }
}

