/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.dialog.component.AttributeSettingPanel;
import jp.sourceforge.tmdmaker.dialog.model.EditCommonAttribute;
import jp.sourceforge.tmdmaker.model.IAttribute;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CommonAttributeDialog
extends Dialog
implements PropertyChangeListener {
    private EditCommonAttribute model;
    private AttributeSettingPanel panel;

    public CommonAttributeDialog(Shell parentShell, List<IAttribute> commonAttributes) {
        super(parentShell);
        this.model = new EditCommonAttribute(commonAttributes);
        this.model.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.panel.updateAttributeTable();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.CommonAttributeSettings);
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.panel = new AttributeSettingPanel(composite, 0, this.model);
        composite.pack();
        return composite;
    }

    public boolean close() {
        this.model.removePropertyChangeListener(this);
        return super.close();
    }

    public List<IAttribute> getEditedAttributes() {
        return this.model.getAttributesOrder();
    }
}

