/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.TMDEditor;
import jp.sourceforge.tmdmaker.dialog.ModelEditDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.editpart.AbstractModelEditPart;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Constraint;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import jp.sourceforge.tmdmaker.property.AbstractEntityModelPropertySource;
import jp.sourceforge.tmdmaker.property.IPropertyAvailable;
import jp.sourceforge.tmdmaker.ui.command.ImplementDerivationModelsDeleteCommand;
import jp.sourceforge.tmdmaker.ui.command.ModelEditCommand;
import jp.sourceforge.tmdmaker.util.ConstraintConverter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class AbstractEntityModelEditPart<T extends AbstractEntityModel>
extends AbstractModelEditPart<T>
implements IPropertyAvailable {
    protected IFigure createFigure() {
        EntityFigure figure = new EntityFigure();
        this.updateFigure((IFigure)figure);
        return figure;
    }

    @Override
    protected abstract void updateFigure(IFigure var1);

    @Override
    protected void onDoubleClicked() {
        ModelEditDialog<T> dialog = this.getDialog();
        if (dialog.open() != 0) {
            return;
        }
        CompoundCommand ccommand = this.createEditCommand(dialog.getEditAttributeList(), (AbstractEntityModel)dialog.getEditedValue());
        this.executeEditCommand((Command)ccommand);
    }

    protected abstract ModelEditDialog<T> getDialog();

    protected CompoundCommand createEditCommand(List<EditAttribute> editAttributeList, AbstractEntityModel editedValue) {
        CompoundCommand ccommand = new CompoundCommand();
        this.addAttributeEditCommands(ccommand, (AbstractEntityModel)this.getModel(), editAttributeList);
        ModelEditCommand command = new ModelEditCommand((AbstractEntityModel)this.getModel(), editedValue);
        ccommand.add((Command)command);
        return ccommand;
    }

    protected void executeEditCommand(Command command) {
        this.getViewer().getEditDomain().getCommandStack().execute(command);
    }

    protected Command getDeleteCommand(AbstractEntityModel editedValue) {
        AbstractEntityModel table = (AbstractEntityModel)this.getModel();
        if (table.isNotImplement() && !editedValue.isNotImplement()) {
            AbstractEntityModel original = ImplementRule.findOriginalImplementModel((AbstractEntityModel)table);
            return new ImplementDerivationModelsDeleteCommand(table, original);
        }
        return null;
    }

    protected Shell getControllShell() {
        return this.getViewer().getControl().getShell();
    }

    protected List<String> extractRelationship(T table) {
        ArrayList<String> relationship = new ArrayList<String>();
        for (Map.Entry rk : table.getReusedIdentifiers().entrySet()) {
            for (Identifier i : ((ReusedIdentifier)rk.getValue()).getUniqueIdentifiers()) {
                relationship.add(i.getName());
            }
        }
        return relationship;
    }

    protected List<String> extractRelationship(T table, IdentifierRef original) {
        ArrayList<String> relationship = new ArrayList<String>();
        for (Map.Entry rk : table.getReusedIdentifiers().entrySet()) {
            for (IdentifierRef i : ((ReusedIdentifier)rk.getValue()).getUniqueIdentifiers()) {
                if (i.isSame(original)) continue;
                relationship.add(i.getName());
            }
        }
        return relationship;
    }

    protected abstract void createEditPolicies();

    protected List getModelChildren() {
        return ((AbstractEntityModel)this.getModel()).getAttributes();
    }

    @Override
    public IPropertySource getPropertySource(TMDEditor editor) {
        return new AbstractEntityModelPropertySource(editor, (AbstractEntityModel)this.getModel());
    }

    @Override
    protected Rectangle convert(Constraint constraint) {
        return ConstraintConverter.toRectangle(constraint);
    }

    @Override
    public boolean canAutoSize() {
        return true;
    }
}

