/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.treeeditpart;

import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.model.Attribute;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.KeyModel;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.treeeditpart.FolderTreeEditPart;
import jp.sourceforge.tmdmaker.treeeditpart.KeyModelTreeEditPart;
import jp.sourceforge.tmdmaker.treeeditpart.TMDOutlineTreeEditPartVisitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TMDEditorOutlineTreePartFactory
implements EditPartFactory {
    private static Logger logger = LoggerFactory.getLogger(TMDEditorOutlineTreePartFactory.class);

    public final EditPart createEditPart(EditPart context, Object model) {
        AbstractTreeEditPart part = null;
        if (model instanceof ModelElement) {
            ModelElement element = (ModelElement)model;
            TMDOutlineTreeEditPartVisitor visitor = new TMDOutlineTreeEditPartVisitor();
            element.accept((IVisitor)visitor);
            return visitor.getEditPart();
        }
        if (model instanceof KeyModel) {
            logger.debug("KeyModel\u7528\u306e EditPart \u3092\u8fd4\u3057\u307e\u3057\u305f");
            logger.debug(((KeyModel)model).getName());
            part = new KeyModelTreeEditPart();
        } else if (model instanceof List) {
            logger.debug("\u30d5\u30a9\u30eb\u30c0\u30fc\u7528EditPart\u3092\u6e96\u5099\u3057\u307e\u3059\u3002");
            List list = (List)model;
            if (list.size() > 0) {
                if (list.get(0) instanceof Identifier) {
                    logger.debug("\u500b\u4f53\u6307\u5b9a\u5b50\u306e\u30d5\u30a9\u30eb\u30c0\u30fc\u7528EditPart\u3092\u8fd4\u3057\u307e\u3057\u305f\u3002");
                    part = new FolderTreeEditPart(Messages.Identifier);
                } else if (list.get(0) instanceof Attribute) {
                    logger.debug("\u5c5e\u6027\u306e\u30d5\u30a9\u30eb\u30c0\u30fc\u7528EditPart\u3092\u8fd4\u3057\u307e\u3057\u305f\u3002");
                    part = new FolderTreeEditPart(Messages.Attribute);
                } else if (list.get(0) instanceof KeyModel) {
                    logger.debug("\u30ad\u30fc\u306e\u30d5\u30a9\u30eb\u30c0\u30fc\u7528EditPart\u3092\u8fd4\u3057\u307e\u3057\u305f\u3002");
                    part = new FolderTreeEditPart(Messages.KeyDefinitions);
                }
            }
        }
        if (part != null) {
            part.setModel(model);
        }
        return part;
    }
}

