/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.IdentifierChangeListener;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.model.parts.ModelName;

public class SubsetType2SubsetRelationship
extends RelatedRelationship
implements IdentifierChangeListener {
    public SubsetType2SubsetRelationship(SubsetType subsetType, ModelName subsetName) {
        super(subsetType, SubsetEntity.build(subsetType.getSuperset(), subsetName));
    }

    @Override
    public void connect() {
        super.connect();
        Diagram diagram = this.getSubsetType().getSuperset().getDiagram();
        if (diagram != null) {
            diagram.addChild(this.getSubsetEntity());
        }
    }

    @Override
    public void disconnect() {
        Diagram diagram = this.getSubsetType().getSuperset().getDiagram();
        if (diagram != null) {
            diagram.removeChild(this.getSubsetEntity());
        }
        super.disconnect();
    }

    public SubsetType getSubsetType() {
        return (SubsetType)this.getSource();
    }

    public SubsetEntity getSubsetEntity() {
        return (SubsetEntity)this.getTarget();
    }

    @Override
    public void identifierChanged() {
        SubsetEntity subset = (SubsetEntity)this.getTarget();
        subset.setOriginalReusedIdentifier(this.getOriginal().createReusedIdentifier());
        subset.fireIdentifierChanged(this);
    }

    private AbstractEntityModel getOriginal() {
        return (AbstractEntityModel)this.getSource().getModelTargetConnections().get(0).getSource();
    }

    @Override
    public String getSourceName() {
        return this.getOriginal().getName();
    }

    @Override
    public String getTargetName() {
        return this.getTarget().getName();
    }
}

