/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.editor.draw2d.figure.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.figure.node.AbstractModelFigure;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;

public class SubsetEntityFigure
extends AbstractModelFigure<SubsetEntity> {
    @Override
    protected List<String> setupIdentifierList(SubsetEntity model) {
        if (model.isSameSubset() && model.getAttributes().size() == 0 && !model.hasRelationship()) {
            return Collections.emptyList();
        }
        if (model.isSupersetAnEntity()) {
            return Arrays.asList(((IdentifierRef)model.getOriginalReusedIdentifier().getUniqueIdentifiers().get(0)).getName());
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> setupRelationshipList(SubsetEntity model) {
        ArrayList<String> relationships = new ArrayList<String>();
        if (!(model.isSameSubset() && model.getAttributes().size() == 0 && !model.hasRelationship() || model.isSupersetAnEntity())) {
            for (Identifier i : model.getOriginalReusedIdentifier().getUniqueIdentifiers()) {
                relationships.add(i.getName());
            }
        }
        List<String> reusedList = super.setupRelationshipList(model);
        relationships.addAll(reusedList);
        return relationships;
    }

    @Override
    protected ModelAppearance getAppearance(SubsetEntity model) {
        ModelAppearance appearance = null;
        if (model.getEntityType().equals((Object)EntityType.RESOURCE)) {
            appearance = ModelAppearance.RESOURCE_SUBSET;
        } else if (model.getEntityType().equals((Object)EntityType.EVENT)) {
            appearance = ModelAppearance.EVENT_SUBSET;
        }
        return appearance;
    }

    @Override
    protected String getTypeLabel(SubsetEntity model) {
        return null;
    }
}

