/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.preferences.appearance;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.TMDPlugin;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AppearancePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Composite colorFields;
    private BooleanFieldEditor editor;
    private List<ColorFieldEditor> colorFieldEditors = new ArrayList<ColorFieldEditor>();
    private List<ColorFieldEditor> fontFieldEditors = new ArrayList<ColorFieldEditor>();

    public AppearancePreferencePage() {
        super(1);
        this.setPreferenceStore(TMDPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        this.setColorFieldsEnabled(this.getPreferenceStore().getBoolean("entityColorEnablePreference"));
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Group colorGroup = new Group(parent, 0);
        colorGroup.setText(Messages.ColorSettings);
        colorGroup.setLayout((Layout)new GridLayout(1, true));
        this.editor = new BooleanFieldEditor("entityColorEnablePreference", Messages.EnableColorSetting, (Composite)colorGroup);
        this.addField((FieldEditor)this.editor);
    }

    private void setColorFieldsEnabled(boolean enabled) {
        for (ColorFieldEditor e : this.colorFieldEditors) {
            e.setEnabled(enabled, this.colorFields);
        }
        for (ColorFieldEditor e : this.fontFieldEditors) {
            e.setEnabled(enabled, this.colorFields);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.setColorFieldsEnabled(this.editor.getBooleanValue());
    }
}

