/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.DataTypeDeclaration;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.ModelElement;

public class Attribute
extends ModelElement
implements IAttribute {
    private String description = "";
    private DataTypeDeclaration dataTypeDeclaration;
    private String validationRule;
    private String lock;
    private String derivationRule;
    private boolean derivation;
    protected String implementName;
    private boolean nullable = false;

    public Attribute() {
    }

    public Attribute(String name) {
        this.setName(name);
    }

    @Override
    public String getImplementName() {
        return this.implementName;
    }

    @Override
    public void setImplementName(String implementName) {
        this.implementName = implementName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getValidationRule() {
        return this.validationRule;
    }

    @Override
    public void setValidationRule(String validationRule) {
        this.validationRule = validationRule;
    }

    @Override
    public String getLock() {
        return this.lock;
    }

    @Override
    public void setLock(String lock) {
        this.lock = lock;
    }

    @Override
    public boolean isDerivation() {
        return this.derivation;
    }

    @Override
    public void setDerivation(boolean derivation) {
        this.derivation = derivation;
    }

    @Override
    public String getDerivationRule() {
        return this.derivationRule;
    }

    @Override
    public void setDerivationRule(String derivationRule) {
        this.derivationRule = derivationRule;
    }

    @Override
    public DataTypeDeclaration getDataTypeDeclaration() {
        return this.dataTypeDeclaration;
    }

    @Override
    public void setDataTypeDeclaration(DataTypeDeclaration dataType) {
        this.dataTypeDeclaration = dataType;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public void copyFrom(IAttribute from) {
        this.setDerivationRule(from.getDerivationRule());
        this.setDerivation(from.isDerivation());
        this.setDescription(from.getDescription());
        this.setLock(from.getLock());
        this.setValidationRule(from.getValidationRule());
        DataTypeDeclaration dtd = from.getDataTypeDeclaration();
        if (dtd != null) {
            this.setDataTypeDeclaration(dtd.getCopy());
        } else {
            this.setDataTypeDeclaration(null);
        }
        this.setImplementName(from.getImplementName());
        this.setNullable(from.isNullable());
        this.setName(from.getName());
    }

    @Override
    public void copyTo(IAttribute to) {
        to.setDerivationRule(this.derivationRule);
        to.setDerivation(this.derivation);
        to.setDescription(this.description);
        to.setLock(this.lock);
        to.setValidationRule(this.validationRule);
        if (this.dataTypeDeclaration != null) {
            to.setDataTypeDeclaration(this.dataTypeDeclaration.getCopy());
        } else {
            to.setDataTypeDeclaration(null);
        }
        to.setImplementName(this.implementName);
        to.setNullable(this.nullable);
        to.setName(this.getName());
    }

    @Override
    public IAttribute getCopy() {
        Attribute copy = new Attribute();
        this.copyTo(copy);
        return copy;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }
}

