/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.dialogs.components;

import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.model.StandardSQLDataType;
import jp.sourceforge.tmdmaker.ui.dialogs.models.EditImplementAttribute;
import jp.sourceforge.tmdmaker.ui.dialogs.models.EditImplementEntity;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ImplementInfoEditPanel
extends Composite {
    private static final String[] NULLABLES = new String[]{Messages.Restriction, Messages.Permit};
    private static final int COLUMN_NO_MODEL_NAME = 0;
    private static final int COLUMN_NO_ATTRIBUTE_NAME = 1;
    private static final int COLUMN_NO_IMPLEMENT_NAME = 2;
    private static final int COLUMN_NO_DATATYPE = 3;
    private static final int COLUMN_NO_SIZE = 4;
    private static final int COLUMN_NO_SCALE = 5;
    private static final int COLUMN_NO_NULLABLE = 6;
    private EditImplementEntity implementModel;
    private int tableSelectedIndex = -1;
    private List<EditImplementAttribute> attributes;
    private TableEditor tableEditor;
    private Label implementNameLabel = null;
    private Text implementNameText = null;
    private Table columnTable = null;

    public ImplementInfoEditPanel(Composite parent, int style, EditImplementEntity implementModel) {
        super(parent, style);
        this.initialize();
        this.implementModel = implementModel;
        this.attributes = implementModel.getAttributes();
        this.pack();
    }

    private void initialize() {
        GridData gridData11 = new GridData();
        gridData11.horizontalAlignment = 4;
        gridData11.horizontalSpan = 2;
        gridData11.heightHint = 150;
        gridData11.grabExcessHorizontalSpace = false;
        gridData11.verticalAlignment = 2;
        GridData gridData10 = new GridData();
        gridData10.horizontalAlignment = 4;
        gridData10.heightHint = 150;
        gridData10.horizontalSpan = 2;
        gridData10.verticalAlignment = 2;
        GridData gridData9 = new GridData();
        gridData9.horizontalAlignment = 4;
        gridData9.heightHint = 150;
        gridData9.horizontalSpan = 2;
        gridData9.verticalAlignment = 2;
        GridData gridData8 = new GridData();
        gridData8.horizontalSpan = 2;
        gridData8.verticalAlignment = 2;
        gridData8.heightHint = 150;
        gridData8.horizontalAlignment = 4;
        GridData gridData7 = new GridData();
        gridData7.horizontalAlignment = 4;
        gridData7.horizontalSpan = 2;
        gridData7.heightHint = 150;
        gridData7.verticalAlignment = 2;
        GridData gridData6 = new GridData();
        gridData6.heightHint = 150;
        gridData6.horizontalAlignment = 4;
        gridData6.verticalAlignment = 2;
        gridData6.horizontalSpan = 2;
        GridData gridData5 = new GridData();
        gridData5.heightHint = 150;
        gridData5.verticalAlignment = 2;
        gridData5.horizontalSpan = 2;
        gridData5.grabExcessHorizontalSpace = true;
        gridData5.horizontalAlignment = 4;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.horizontalSpan = 2;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.grabExcessVerticalSpace = false;
        gridData3.heightHint = 100;
        gridData3.verticalAlignment = 2;
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = false;
        gridData1.verticalAlignment = 2;
        gridData1.horizontalAlignment = 4;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 0;
        gridData.heightHint = 200;
        gridData.verticalAlignment = 2;
        this.implementNameLabel = new Label((Composite)this, 0);
        this.implementNameLabel.setText(Messages.ImplementationName);
        this.implementNameText = new Text((Composite)this, 2048);
        this.implementNameText.setLayoutData((Object)gridData1);
        this.implementNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImplementInfoEditPanel.this.implementModel.setImplementName(((Text)e.widget).getText());
            }
        });
        this.columnTable = new Table((Composite)this, 65540);
        this.tableEditor = new TableEditor(this.columnTable);
        this.tableEditor.grabHorizontal = true;
        this.tableEditor.horizontalAlignment = 16384;
        this.tableEditor.minimumWidth = 25;
        this.columnTable.setHeaderVisible(true);
        this.columnTable.setLayoutData((Object)gridData11);
        this.columnTable.setLayoutData((Object)gridData10);
        this.columnTable.setLayoutData((Object)gridData9);
        this.columnTable.setLayoutData((Object)gridData8);
        this.columnTable.setLayoutData((Object)gridData7);
        this.columnTable.setLayoutData((Object)gridData6);
        this.columnTable.setLayoutData((Object)gridData5);
        this.columnTable.setLayoutData((Object)gridData3);
        this.columnTable.setLayoutData((Object)gridData);
        this.columnTable.setLinesVisible(true);
        TableColumn tableColumn11 = new TableColumn(this.columnTable, 0);
        tableColumn11.setWidth(150);
        tableColumn11.setText(Messages.ModelName);
        this.columnTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Control control;
                Point point;
                TableItem item;
                int selectedColumnIndex;
                ImplementInfoEditPanel.this.tableSelectedIndex = ImplementInfoEditPanel.this.columnTable.getSelectionIndex();
                if (ImplementInfoEditPanel.this.tableSelectedIndex == -1) {
                    return;
                }
                Control oldEditor = ImplementInfoEditPanel.this.tableEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((selectedColumnIndex = ImplementInfoEditPanel.this.getSelectedColumnIndex(item = ImplementInfoEditPanel.this.columnTable.getItem(ImplementInfoEditPanel.this.tableSelectedIndex), point = new Point(e.x, e.y))) != -1 && (control = ImplementInfoEditPanel.this.createEditorControl(selectedColumnIndex, ImplementInfoEditPanel.this.columnTable, item)) != null) {
                    ImplementInfoEditPanel.this.addEventListeners(control);
                    ImplementInfoEditPanel.this.columnTable.setSelection(new int[0]);
                    ImplementInfoEditPanel.this.tableEditor.setEditor(control, item, selectedColumnIndex);
                    if (control instanceof Text) {
                        ((Text)control).selectAll();
                    }
                    control.setFocus();
                }
            }
        });
        TableColumn tableColumn = new TableColumn(this.columnTable, 0);
        tableColumn.setWidth(150);
        tableColumn.setText(Messages.AttributeName);
        TableColumn tableColumn1 = new TableColumn(this.columnTable, 0);
        tableColumn1.setWidth(150);
        tableColumn1.setText(Messages.ImplementationName);
        TableColumn tableColumn2 = new TableColumn(this.columnTable, 0);
        tableColumn2.setWidth(150);
        tableColumn2.setText(Messages.DataType);
        TableColumn tableColumn21 = new TableColumn(this.columnTable, 0);
        tableColumn21.setWidth(50);
        tableColumn21.setText(Messages.Size);
        TableColumn tableColumn31 = new TableColumn(this.columnTable, 0);
        tableColumn31.setWidth(50);
        tableColumn31.setText(Messages.Scale);
        TableColumn tableColumn3 = new TableColumn(this.columnTable, 0);
        tableColumn3.setWidth(60);
        tableColumn3.setText(Messages.Null);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.setSize(new Point(765, 249));
    }

    private int getSelectedColumnIndex(TableItem item, Point point) {
        int i = 0;
        while (i < this.columnTable.getColumnCount()) {
            if (item.getBounds(i).contains(point)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void addEventListeners(Control control) {
        if (control instanceof Text) {
            final Text text = (Text)control;
            text.addFocusListener((FocusListener)new FocusAdapter(){
                int forcusGainIndex = -1;

                public void focusGained(FocusEvent e) {
                    this.forcusGainIndex = ImplementInfoEditPanel.this.tableSelectedIndex;
                    super.focusGained(e);
                }

                public void focusLost(FocusEvent e) {
                    ImplementInfoEditPanel.this.setData(ImplementInfoEditPanel.this.tableEditor.getColumn(), text.getText(), this.forcusGainIndex);
                    ImplementInfoEditPanel.this.updateTable();
                    text.dispose();
                }
            });
            this.columnTable.setSelection(new int[0]);
            text.selectAll();
            text.setFocus();
        } else if (control instanceof Combo) {
            final Combo combo = (Combo)control;
            combo.addFocusListener((FocusListener)new FocusAdapter(){
                int forcusGainedIndex = -1;

                public void focusGained(FocusEvent e) {
                    this.forcusGainedIndex = ImplementInfoEditPanel.this.tableSelectedIndex;
                    super.focusGained(e);
                }

                public void focusLost(FocusEvent e) {
                    int index = combo.getSelectionIndex();
                    if (index != -1) {
                        ImplementInfoEditPanel.this.setData(ImplementInfoEditPanel.this.tableEditor.getColumn(), String.valueOf(index), this.forcusGainedIndex);
                        ImplementInfoEditPanel.this.updateTable();
                    }
                    combo.dispose();
                }
            });
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = combo.getSelectionIndex();
                    if (index != -1) {
                        ImplementInfoEditPanel.this.setData(ImplementInfoEditPanel.this.tableEditor.getColumn(), String.valueOf(index), ImplementInfoEditPanel.this.tableSelectedIndex);
                        ImplementInfoEditPanel.this.updateTable();
                    }
                    combo.dispose();
                }
            });
        }
    }

    public void updateTable() {
        this.implementNameText.setText(this.implementModel.getImplementName());
        this.columnTable.removeAll();
        for (EditImplementAttribute a : this.attributes) {
            TableItem item = new TableItem(this.columnTable, 0);
            item.setText(0, a.getContainerModel().getName());
            item.setText(1, a.getName());
            item.setText(2, a.getImplementName());
            StandardSQLDataType type = a.getDataType();
            if (type != null) {
                item.setText(3, type.getName());
                if (type.isSupportSize()) {
                    item.setText(4, a.getSize());
                } else {
                    item.setText(4, "");
                }
                if (type.isSupportScale()) {
                    item.setText(5, a.getScale());
                } else {
                    item.setText(5, "");
                }
            } else {
                item.setText(3, "");
                item.setText(4, "");
                item.setText(5, "");
            }
            if (a.isNullable()) {
                item.setText(6, NULLABLES[1]);
                continue;
            }
            item.setText(6, NULLABLES[0]);
        }
    }

    private void setData(int columnIndex, String value, int attributeIndex) {
        EditImplementAttribute a = this.attributes.get(attributeIndex);
        switch (columnIndex) {
            case 1: {
                a.setName(value);
                break;
            }
            case 2: {
                a.setImplementName(value);
                break;
            }
            case 3: {
                int index = Integer.parseInt(value);
                if (index > 0) {
                    a.setDataType(StandardSQLDataType.values()[index - 1]);
                    if (!a.getDataType().isSupportSize()) {
                        a.setSize("");
                    }
                    if (a.getDataType().isSupportScale()) break;
                    a.setScale("");
                    break;
                }
                a.setDataType(null);
                a.setSize("");
                a.setScale("");
                break;
            }
            case 4: {
                a.setSize(value);
                break;
            }
            case 5: {
                a.setScale(value);
                break;
            }
            case 6: {
                int selectedIndex = Integer.parseInt(value);
                a.setNullable(selectedIndex == 1);
                break;
            }
        }
    }

    private Control createEditorControl(int columnIndex, Table columnTable, TableItem item) {
        Combo control = null;
        switch (columnIndex) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                control = this.createImplementNameColumn(columnIndex, columnTable, item);
                break;
            }
            case 3: {
                control = this.createDatatypeColumn(columnTable);
                break;
            }
            case 4: {
                control = this.createSizeColumn(columnIndex, columnTable, item, (Control)control);
                break;
            }
            case 5: {
                control = this.createScaleColumn(columnIndex, columnTable, item, (Control)control);
                break;
            }
            case 6: {
                control = this.createNullableColumn(columnIndex, columnTable, item);
                break;
            }
        }
        return control;
    }

    private Combo createNullableColumn(int columnIndex, Table columnTable, TableItem item) {
        Combo nullableCombo = new Combo((Composite)columnTable, 8);
        String value = item.getText(columnIndex);
        int index = 0;
        int i = 0;
        while (i < NULLABLES.length) {
            String s = NULLABLES[i];
            if (s.equals(value)) {
                index = i;
            }
            nullableCombo.add(s);
            ++i;
        }
        nullableCombo.select(index);
        return nullableCombo;
    }

    private Control createScaleColumn(int columnIndex, Table columnTable, TableItem item, Control control) {
        StandardSQLDataType type = this.attributes.get(this.tableSelectedIndex).getDataType();
        if (type != null && type.isSupportScale()) {
            control = this.createImplementNameColumn(columnIndex, columnTable, item);
        }
        return control;
    }

    private Control createSizeColumn(int columnIndex, Table columnTable, TableItem item, Control control) {
        StandardSQLDataType type = this.attributes.get(this.tableSelectedIndex).getDataType();
        if (type != null && type.isSupportSize()) {
            control = this.createImplementNameColumn(columnIndex, columnTable, item);
        }
        return control;
    }

    private Combo createDatatypeColumn(Table columnTable) {
        Combo dataTypeCombo = new Combo((Composite)columnTable, 8);
        int index = 0;
        StandardSQLDataType type = this.attributes.get(this.tableSelectedIndex).getDataType();
        if (type != null) {
            index = type.ordinal() + 1;
        }
        dataTypeCombo.add("");
        StandardSQLDataType[] standardSQLDataTypeArray = StandardSQLDataType.values();
        int n = standardSQLDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardSQLDataType dataType = standardSQLDataTypeArray[n2];
            dataTypeCombo.add(dataType.getName());
            ++n2;
        }
        dataTypeCombo.select(index);
        return dataTypeCombo;
    }

    private Control createImplementNameColumn(int columnIndex, Table columnTable, TableItem item) {
        Text text = new Text((Composite)columnTable, 0);
        text.setText(item.getText(columnIndex));
        Text control = text;
        return control;
    }

    public String getImplementName() {
        return this.implementNameText.getText();
    }

    public List<EditImplementAttribute> getAttributes() {
        return this.attributes;
    }
}

