/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.editor.gef3.editparts.node;

import java.beans.PropertyChangeEvent;
import jp.sourceforge.tmdmaker.TMDEditor;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Attribute;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.ui.editor.gef3.editparts.IAttributeEditPart;
import jp.sourceforge.tmdmaker.ui.editor.gef3.editparts.node.AbstractTMDEditPart;
import jp.sourceforge.tmdmaker.ui.editor.gef3.editpolicies.AttributeComponentEditPolicy;
import jp.sourceforge.tmdmaker.ui.views.properties.IAttributePropertySource;
import jp.sourceforge.tmdmaker.ui.views.properties.IPropertyAvailable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.EditPolicy;
import org.eclipse.ui.views.properties.IPropertySource;

public class AttributeEditPart
extends AbstractTMDEditPart<Attribute>
implements IPropertyAvailable,
IAttributeEditPart {
    public AttributeEditPart(Attribute attribute) {
        this.setModel(attribute);
    }

    protected IFigure createFigure() {
        Label label = new Label();
        label.setText(this.createAttributeName((Attribute)this.getModel()));
        label.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        label.setLabelAlignment(1);
        return label;
    }

    private String createAttributeName(Attribute attribute) {
        StringBuilder name = new StringBuilder(attribute.getName());
        if (attribute.isDerivation()) {
            name.append("(D)");
        }
        return name.toString();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new AttributeComponentEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_property_name")) {
            this.logger.debug("Handle Name Event.");
            this.handleNameChange(evt);
        } else {
            this.logger.warn("Not Handle Event Occured.");
        }
    }

    protected void refreshVisuals() {
        Label f = (Label)this.getFigure();
        f.setText(this.createAttributeName((Attribute)this.getModel()));
        this.getParent().refresh();
    }

    protected void handleNameChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    @Override
    public IPropertySource getPropertySource(TMDEditor editor) {
        return new IAttributePropertySource(editor, (IAttribute)this.getModel());
    }

    @Override
    public AbstractEntityModel getParentModel() {
        return (AbstractEntityModel)this.getParent().getModel();
    }
}

