/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.preferences.appearance;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class FontAppearancePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Composite colorFields;
    private List<ColorFieldEditor> fontFieldEditors = new ArrayList<ColorFieldEditor>();
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("entityColorEnablePreference")) {
                Boolean colorEnabled = (Boolean)event.getNewValue();
                FontAppearancePreferencePage.this.setColorFieldsEnabled(colorEnabled);
            }
        }
    };

    public FontAppearancePreferencePage() {
        super(1);
        this.setPreferenceStore(TMDPlugin.getDefault().getPreferenceStore());
        this.getPreferenceStore().addPropertyChangeListener(this.listener);
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        this.setColorFieldsEnabled(this.getPreferenceStore().getBoolean("entityColorEnablePreference"));
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Group colorGroup = new Group(parent, 0);
        colorGroup.setText(Messages.ColorSettings);
        colorGroup.setLayout((Layout)new GridLayout(1, true));
        this.colorFields = new Composite((Composite)colorGroup, 0);
        new Label(this.colorFields, 0);
        Label l = new Label(this.colorFields, 0);
        l.setText(Messages.BorderFont);
        ModelAppearance[] modelAppearanceArray = ModelAppearance.values();
        int n = modelAppearanceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelAppearance a = modelAppearanceArray[n2];
            this.fontFieldEditors.add(new ColorFieldEditor(a.getFontColorPropertyName(), a.getLabel(), this.colorFields));
            ++n2;
        }
        for (ColorFieldEditor e : this.fontFieldEditors) {
            this.addField((FieldEditor)e);
        }
    }

    private void setColorFieldsEnabled(boolean enabled) {
        for (ColorFieldEditor e : this.fontFieldEditors) {
            e.setEnabled(enabled, this.colorFields);
        }
    }

    public void dispose() {
        this.getPreferenceStore().removePropertyChangeListener(this.listener);
        super.dispose();
    }
}

