/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.generate.ddl.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignConstraints {
    private static Logger logger = LoggerFactory.getLogger(ForeignConstraints.class);
    Table table;
    Map<String, List<Reference>> foreignReferences;
    Map<String, List<Reference>> recursiveForeignReferences;

    public ForeignConstraints(Table table) {
        this.table = table;
        this.foreignReferences = new HashMap<String, List<Reference>>();
        this.recursiveForeignReferences = new HashMap<String, List<Reference>>();
    }

    public void addForeignReference(String foreignTableName, List<Reference> references, boolean isRecursive) {
        logger.trace("addForeignReference() {} {} {}", new Object[]{foreignTableName, references.size(), isRecursive});
        if (isRecursive) {
            this.addRecursiveForeignReference(foreignTableName, references);
        } else {
            this.addNonRecursiveForeignReference(foreignTableName, references);
        }
    }

    private void addNonRecursiveForeignReference(String tableName, List<Reference> references) {
        this.foreignReferences.put(tableName, references);
    }

    private void addRecursiveForeignReference(String tableName, List<Reference> references) {
        this.recursiveForeignReferences.put(tableName, references);
    }

    public void addForeignKeys(Database database) {
        Table foreignTable;
        for (Map.Entry<String, List<Reference>> foreignmap : this.foreignReferences.entrySet()) {
            foreignTable = database.findTable(foreignmap.getKey());
            if (foreignTable == null) continue;
            this.addForeignKey(foreignTable, foreignmap.getValue());
        }
        for (Map.Entry<String, List<Reference>> foreignmap : this.recursiveForeignReferences.entrySet()) {
            foreignTable = database.findTable(foreignmap.getKey());
            if (foreignTable == null) continue;
            this.addForeignKey(foreignTable, foreignmap.getValue(), 1);
            this.addForeignKey(foreignTable, foreignmap.getValue(), 2);
        }
    }

    private void addForeignKey(Table foreignTable, List<Reference> references) {
        this.addForeignKey(foreignTable, references, null);
    }

    private void addForeignKey(Table foreignTable, List<Reference> references, Integer no) {
        String foreignKeyName = no != null ? "FK_" + no.toString() + foreignTable.getName() : "FK_" + foreignTable.getName();
        ForeignKey foreignKey = new ForeignKey(foreignKeyName);
        for (Reference ref : references) {
            foreignKey.addReference(ref);
        }
        foreignKey.setForeignTable(foreignTable);
        this.table.addForeignKey(foreignKey);
    }
}

