/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.core.model.KeyModel;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.dialogs.components.IndexPanel;
import org.tmdmaker.ui.dialogs.model.EditImplementAttribute;

public class IndexEditDialog
extends Dialog {
    private IndexPanel panel;
    private KeyModel keyModel;
    private List<IAttribute> attributes;

    public IndexEditDialog(Shell parentShell, String implementEntityName, List<EditImplementAttribute> editAttributeList) {
        super(parentShell);
        this.keyModel = new KeyModel();
        this.attributes = this.convert(editAttributeList);
        this.keyModel.setName(this.createKeyName(implementEntityName, editAttributeList));
    }

    private String createKeyName(String implementEntityName, List<EditImplementAttribute> editAttributeList) {
        String modelName = null;
        int keyCount = 0;
        if (editAttributeList != null && editAttributeList.size() > 0) {
            EditImplementAttribute a = editAttributeList.get(0);
            modelName = implementEntityName;
            keyCount = a.getKeyCount();
        } else {
            modelName = "";
        }
        return String.valueOf(modelName) + "_IDX" + (keyCount + 1);
    }

    public IndexEditDialog(Shell parentShell, KeyModel keyModel, List<EditImplementAttribute> editAttributeList) {
        super(parentShell);
        this.keyModel = keyModel;
        this.attributes = this.convert(editAttributeList);
        this.attributes.removeAll(keyModel.getAttributes());
    }

    private List<IAttribute> convert(List<EditImplementAttribute> sourceList) {
        ArrayList<IAttribute> targetList = new ArrayList<IAttribute>();
        for (EditImplementAttribute ea : sourceList) {
            targetList.add(ea.getOriginalAttribute());
        }
        return targetList;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.EditKey);
        Composite composite = new Composite(parent, 0);
        this.panel = new IndexPanel(composite, 0);
        this.panel.initializeValue(this.keyModel, this.attributes);
        composite.pack();
        return composite;
    }

    protected void okPressed() {
        this.keyModel.setName(this.panel.getIndexName());
        this.keyModel.setUnique(this.panel.isUnique());
        this.keyModel.setAttributes(this.panel.getSelectModels());
        this.keyModel.setMasterKey(this.panel.isMasterKey());
        super.okPressed();
    }

    public KeyModel getKeyModel() {
        return this.keyModel;
    }
}

