/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.draw2d.adjuster;

import java.util.List;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.ModelElement;
import org.tmdmaker.core.model.SubsetEntity;
import org.tmdmaker.core.model.SubsetType;
import org.tmdmaker.ui.editor.draw2d.ConstraintAdjuster;
import org.tmdmaker.ui.editor.draw2d.ConstraintConverter;

public class SubsetAdjuster
implements ConstraintAdjuster {
    private AbstractEntityModel superset;
    private List<SubsetEntity> addSubsetEntityList;

    public SubsetAdjuster(AbstractEntityModel superset, List<SubsetEntity> addSubsetEntityList) {
        this.superset = superset;
        this.addSubsetEntityList = addSubsetEntityList;
    }

    @Override
    public void adjust() {
        int subsetwidth = this.calcurateSubsetWidth();
        int totalWidthHalf = this.addSubsetEntityList.size() * subsetwidth / 2;
        SubsetType subsetType = this.superset.subsets().subsetType();
        int subsetX = totalWidthHalf * -1 + subsetType.getConstraint().getX();
        int SUBSET_Y = 50 + subsetType.getConstraint().getY();
        for (SubsetEntity s : this.addSubsetEntityList) {
            ConstraintConverter.setConstraint((ModelElement)s, subsetX, SUBSET_Y);
            subsetX += subsetwidth;
        }
    }

    private int calcurateSubsetWidth() {
        int subsetNameLength = this.calcurateSubsetNameSize();
        int reusedNameLength = this.superset.calcurateMaxIdentifierRefSize();
        int charLength = Math.max(subsetNameLength, reusedNameLength) * 12;
        return charLength + 14;
    }

    private int calcurateSubsetNameSize() {
        int nameLength = 0;
        for (SubsetEntity e : this.addSubsetEntityList) {
            nameLength = Math.max(nameLength, e.getName().length());
        }
        return nameLength;
    }
}

