/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.sphinx.attributelist;

import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Entity;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.sphinx.utilities.SphinxUtils;

public class AttributeListRstGenerator {
    public static void generateAttributeList(List<AbstractEntityModel> models, File outputdir) {
        final File attributesDir = new File(outputdir, "attribute_list");
        attributesDir.mkdirs();
        CharSequence _attributeList = AttributeListRstGenerator.attributeList(models);
        File _file = new File(outputdir, "attribute_list.rst");
        SphinxUtils.writeTo(_attributeList, _file);
        Consumer<AbstractEntityModel> _function = new Consumer<AbstractEntityModel>(){

            @Override
            public void accept(final AbstractEntityModel model) {
                Consumer<IAttribute> _function = new Consumer<IAttribute>(){

                    @Override
                    public void accept(IAttribute attr) {
                        CharSequence _generateRst = AttributeListRstGenerator.generateRst(attr, model);
                        StringConcatenation _builder = new StringConcatenation();
                        CharSequence _fileName = AttributeListRstGenerator.getFileName(attr, model);
                        _builder.append((Object)_fileName);
                        _builder.append(".rst");
                        File _file = new File(attributesDir, _builder.toString());
                        SphinxUtils.writeTo(_generateRst, _file);
                    }
                };
                model.getAttributes().forEach(_function);
            }
        };
        models.forEach(_function);
    }

    private static CharSequence attributeList(List<AbstractEntityModel> models) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\u30a2\u30c8\u30ea\u30d3\u30e5\u30fc\u30c8\u30ea\u30b9\u30c8");
        _builder.newLine();
        _builder.append("=====================");
        _builder.newLine();
        _builder.newLine();
        for (AbstractEntityModel model : models) {
            List _attributes = model.getAttributes();
            for (IAttribute attr : _attributes) {
                String _name = attr.getName();
                _builder.append(_name);
                _builder.newLineIfNotEmpty();
                _builder.append("-------------------------------------------------------");
                _builder.newLine();
                _builder.newLine();
                _builder.append(".. toctree::");
                _builder.newLine();
                _builder.append("   ");
                _builder.append(":maxdepth: 1");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("attribute_list/");
                CharSequence _fileName = AttributeListRstGenerator.getFileName(attr, model);
                _builder.append((Object)_fileName, "    ");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
            }
        }
        return _builder;
    }

    private static CharSequence getFileName(IAttribute attribute, AbstractEntityModel entity) {
        StringConcatenation _builder = new StringConcatenation();
        String _implementName = entity.getImplementName();
        _builder.append(_implementName);
        _builder.append("_");
        String _implementName_1 = attribute.getImplementName();
        _builder.append(_implementName_1);
        return _builder;
    }

    private static CharSequence generateRst(IAttribute attribute, AbstractEntityModel model) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = attribute.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        int _length = attribute.getName().length();
        int _multiply = _length * 2;
        String _repeat = StringUtils.repeat((String)"=", (int)_multiply);
        _builder.append(_repeat);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\u6240\u5c5e\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3");
        _builder.newLine();
        _builder.append("----------------");
        _builder.newLine();
        _builder.newLine();
        String _name_1 = model.getName();
        _builder.append(_name_1);
        _builder.append(" ");
        if (model instanceof Entity) {
            _builder.append("(");
            String _typeName = ((Entity)model).getEntityType().getTypeName();
            _builder.append(_typeName);
            _builder.append(")");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\u6458\u8981");
        _builder.newLine();
        _builder.append("----");
        _builder.newLine();
        _builder.newLine();
        String _description = attribute.getDescription();
        _builder.append(_description);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\u524d\u63d0");
        _builder.newLine();
        _builder.append("----");
        _builder.newLine();
        _builder.newLine();
        String _validationRule = attribute.getValidationRule();
        _builder.append(_validationRule);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\u6a5f\u5bc6\u6027");
        _builder.newLine();
        _builder.append("------");
        _builder.newLine();
        _builder.newLine();
        String _lock = attribute.getLock();
        _builder.append(_lock);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\u8a08\u7b97\u5f0f");
        _builder.newLine();
        _builder.append("------");
        _builder.newLine();
        _builder.newLine();
        String _derivationRule = attribute.getDerivationRule();
        _builder.append(_derivationRule);
        _builder.newLineIfNotEmpty();
        return _builder;
    }
}

