/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.serializer.handler.patch;

import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Detail;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.core.model.Entity;
import org.tmdmaker.serializer.handler.patch.AbstractSerializerHandler;

public class Patch090SerializerHandler
extends AbstractSerializerHandler {
    @Override
    public String handleBeforeDeserialize(String in) {
        return in.replace("jp.sourceforge.tmdmaker.model.", "org.tmdmaker.core.model.");
    }

    @Override
    public Diagram handleAfterDeserialize(Diagram in) {
        this.logger.info("handleAfterDeserialize");
        if (this.versionUnderEqual(in, 0, 9, 0)) {
            this.logger.info("apply patch 0.9.0");
            for (AbstractEntityModel model : in.query().listEntityModel()) {
                if (model instanceof Entity) {
                    this.logger.info("Entity found. {}", (Object)model.getName());
                    Entity entity = (Entity)model;
                    entity.setIdentifier(entity.getIdentifier());
                }
                if (!(model instanceof Detail)) continue;
                this.logger.info("Detail found. {}", (Object)model.getName());
                Detail detail = (Detail)model;
                detail.setDetailIdentifier(detail.getDetailIdentifier());
            }
        }
        return in;
    }
}

