/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.views.properties.gef3;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.CombinationTable;
import org.tmdmaker.core.model.Detail;
import org.tmdmaker.core.model.Laputa;
import org.tmdmaker.core.model.MappingList;
import org.tmdmaker.core.model.MultivalueOrEntity;
import org.tmdmaker.core.model.RecursiveTable;
import org.tmdmaker.core.model.SubsetEntity;
import org.tmdmaker.core.model.VirtualEntity;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.views.properties.gef3.AbstractPropertySource;
import org.tmdmaker.ui.views.properties.gef3.commands.PropertyChangeCommand;

public class AbstractEntityModelPropertySource
extends AbstractPropertySource {
    protected static final String[] IMPLEMENT_LABELS = new String[]{Messages.Implementation, Messages.NotToImplement};
    protected static final int IMPLEMENTATION_INDEX = 0;
    protected static final int NOT_IMPLEMEN_INDEX = 1;
    protected static final String IMPLEMENT = "notImplement";
    protected static final String ENTITY_TYPE = "entityType";
    protected static final String IMPLEMENT_NAME = "implementName";
    protected static final String NAME = "name";
    protected AbstractEntityModel model;
    protected IPropertyDescriptor[] propertyFields;

    public AbstractEntityModelPropertySource(CommandStack commandStack, AbstractEntityModel model) {
        super(commandStack);
        this.model = model;
        this.propertyFields = this.buildPropertyDescriptors();
    }

    public Object getEditableValue() {
        return this.model;
    }

    protected IPropertyDescriptor[] buildPropertyDescriptors() {
        return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)NAME, Messages.ModelName), new TextPropertyDescriptor((Object)IMPLEMENT_NAME, Messages.ImplementationName), new PropertyDescriptor((Object)ENTITY_TYPE, Messages.EntityType), new ComboBoxPropertyDescriptor((Object)IMPLEMENT, Messages.Implementation, IMPLEMENT_LABELS)};
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyFields;
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(ENTITY_TYPE)) {
            return this.getEntityType();
        }
        if (id.equals(IMPLEMENT)) {
            return this.model.isNotImplement() ? 1 : 0;
        }
        return this.getPropertyValue(this.model, id.toString());
    }

    protected Object getEntityType() {
        if (this.model instanceof CombinationTable) {
            return Messages.CombinationTable;
        }
        if (this.model instanceof SubsetEntity) {
            return Messages.Subset;
        }
        if (this.model instanceof VirtualEntity) {
            return Messages.VirtualEntity;
        }
        if (this.model instanceof MultivalueOrEntity) {
            return Messages.MultivalueOR;
        }
        if (this.model instanceof Detail) {
            return Messages.MultivalueAndDetail;
        }
        if (this.model instanceof RecursiveTable) {
            return Messages.RecursiveTable;
        }
        if (this.model instanceof MappingList) {
            return Messages.MappingList;
        }
        if (this.model instanceof Laputa) {
            return Messages.Laputa;
        }
        return null;
    }

    @Override
    protected Command createSetPropertyCommand(Object id, Object value) {
        String propertyName = id.toString();
        Object oldValue = this.getPropertyValue(this.model, propertyName);
        oldValue = this.handleOldPropertyValue(propertyName, oldValue, value);
        value = this.handleSetNewPropertyValue(propertyName, oldValue, value);
        return new PropertyChangeCommand(this.model, propertyName, oldValue, value);
    }

    protected Object handleOldPropertyValue(String propertyName, Object oldValue, Object newValue) {
        if (propertyName.equals(IMPLEMENT)) {
            return this.model.isNotImplement();
        }
        return oldValue;
    }

    protected Object handleSetNewPropertyValue(String propertyName, Object oldValue, Object newValue) {
        if (propertyName.equals(IMPLEMENT)) {
            if ((Integer)newValue == 1) {
                return true;
            }
            return false;
        }
        return newValue;
    }
}

