/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.dialogs;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.core.model.VirtualSuperset;
import org.tmdmaker.core.model.VirtualSupersetType;
import org.tmdmaker.core.model.parts.ModelName;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.dialogs.components.ModelSelectPanel;
import org.tmdmaker.ui.dialogs.components.VirtualSupersetSettingPanel;

public class VirtualSupersetCreateDialog
extends Dialog {
    private VirtualSupersetSettingPanel panel1;
    private ModelSelectPanel panel2;
    private VirtualSuperset superset;
    private VirtualSuperset editedValue;
    private VirtualSupersetType editedAggregator;
    private List<AbstractEntityModel> notSelection;
    private List<AbstractEntityModel> selection;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text t = (Text)e.getSource();
            String name = t.getText();
            Button okButton = VirtualSupersetCreateDialog.this.getButton(0);
            if (okButton != null) {
                okButton.setEnabled(name.length() != 0);
            }
        }
    };

    public VirtualSupersetCreateDialog(Shell parentShell, Diagram diagram, VirtualSuperset superset, List<AbstractEntityModel> selectedList) {
        super(parentShell);
        this.superset = superset;
        this.selection = this.setupSelection(selectedList);
        ArrayList<AbstractEntityModel> excludes = new ArrayList<AbstractEntityModel>(this.selection);
        excludes.add((AbstractEntityModel)superset);
        this.notSelection = diagram.query().exclude(excludes).listEntityModel();
    }

    private List<AbstractEntityModel> setupSelection(List<AbstractEntityModel> selectedList) {
        ArrayList<AbstractEntityModel> distinctList = new ArrayList<AbstractEntityModel>();
        LinkedHashSet<AbstractEntityModel> selectionTarget = new LinkedHashSet<AbstractEntityModel>();
        if (this.superset != null) {
            selectionTarget.addAll(this.superset.getVirtualSubsetList());
        }
        selectionTarget.addAll(selectedList);
        distinctList.addAll(selectionTarget);
        return distinctList;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.EditVirtualSuperset);
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.panel1 = new VirtualSupersetSettingPanel(composite, 0);
        GridData gridData = new GridData(768);
        this.panel1.setLayoutData(gridData);
        this.panel1.addNameModifyListener(this.listener);
        this.panel2 = new ModelSelectPanel(composite, 0);
        gridData = new GridData(768);
        this.panel2.setLayoutData(gridData);
        composite.pack();
        return composite;
    }

    protected void okPressed() {
        this.editedValue = VirtualSuperset.of((ModelName)new ModelName(this.panel1.getVirtualSupersetName()));
        this.editedAggregator = new VirtualSupersetType();
        this.editedAggregator.setApplyAttribute(this.panel1.isApplyAttributeSelected());
        super.okPressed();
    }

    public boolean close() {
        this.panel1.removeNameModifyListener(this.listener);
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button okButton = this.getButton(0);
        okButton.setEnabled(false);
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.panel1.initializeValue(this.superset);
        this.panel2.initializeValue(this.selection, this.notSelection);
        return c;
    }

    public VirtualSuperset getEditedValue() {
        return this.editedValue;
    }

    public List<AbstractEntityModel> getNotSelection() {
        return this.notSelection;
    }

    public List<AbstractEntityModel> getSelection() {
        return this.selection;
    }

    public VirtualSupersetType getEditedAggregator() {
        return this.editedAggregator;
    }
}

