/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.draw2d.figure.node;

import java.util.List;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.tmdmaker.ui.editor.draw2d.figure.node.ColorConverter;
import org.tmdmaker.ui.preferences.appearance.ModelAppearance;

public class TFormFigure
extends Figure {
    protected Label name = new Label();
    protected Label type = new Label();
    protected EntityTitleCompartmentFigure titleCompartmentFigure = new EntityTitleCompartmentFigure();
    protected EntityLayoutCompartmentFigure compartmentFigure = new EntityLayoutCompartmentFigure();
    protected CompartmentFigure identifierCompartmentFigure = new CompartmentFigure();
    protected CompartmentFigure attributeCompartmentFigure = new CompartmentFigure();

    public TFormFigure() {
        this(false);
    }

    public TFormFigure(boolean notImplement) {
        ToolbarLayout layout = new ToolbarLayout();
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new EntityFigureBorder(notImplement));
        this.setOpaque(true);
        this.titleCompartmentFigure.setEntityName((Figure)this.name);
        this.titleCompartmentFigure.setEntityType((Figure)this.type);
        this.add((IFigure)this.titleCompartmentFigure);
        this.add((IFigure)this.compartmentFigure);
        this.attributeCompartmentFigure.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        this.compartmentFigure.add((IFigure)this.identifierCompartmentFigure);
        this.compartmentFigure.add((IFigure)this.attributeCompartmentFigure);
    }

    protected void setEntityName(String entityName) {
        this.name.setText(entityName);
    }

    protected void setEntityType(String entityType) {
        if (entityType != null) {
            this.type.setText(entityType);
        }
    }

    protected void addIdentifier(String identifier) {
        this.identifierCompartmentFigure.add((IFigure)this.createAttributeLabel(identifier));
    }

    protected void addIdentifier(List<String> identifierList) {
        for (String i : identifierList) {
            this.addIdentifier(i);
        }
    }

    protected void addRelationship(List<String> relationshipList) {
        for (String r : relationshipList) {
            this.addRelationship(r);
        }
    }

    protected void addRelationship(String relationship) {
        this.identifierCompartmentFigure.add((IFigure)this.createAttributeLabel(String.valueOf(relationship) + "(R)"));
    }

    protected void removeAllRelationship() {
        this.identifierCompartmentFigure.removeAll();
    }

    protected void setNotImplement(boolean notImplement) {
        this.setBorder((Border)new EntityFigureBorder(notImplement));
    }

    protected void setupColor(ModelAppearance appearance) {
        ColorConverter converter = new ColorConverter(appearance);
        this.setForegroundColor(converter.createForegroundColor());
        this.setBackgroundColor(converter.createBackgroundColor());
    }

    public CompartmentFigure getAttributeCompartmentFigure() {
        return this.attributeCompartmentFigure;
    }

    protected Label createAttributeLabel(String name) {
        Label tmp = new Label(name);
        tmp.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        tmp.setLabelAlignment(1);
        return tmp;
    }

    protected static class CompartmentFigure
    extends Figure {
        public CompartmentFigure() {
            ToolbarLayout layout = new ToolbarLayout();
            layout.setMinorAlignment(1);
            layout.setStretchMinorAxis(true);
            layout.setSpacing(0);
            this.setLayoutManager((LayoutManager)layout);
        }
    }

    protected class EntityFigureBorder
    extends LineBorder {
        private boolean notImplement;

        public EntityFigureBorder(boolean notImplement) {
            this.notImplement = notImplement;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            boolean attributeNotEmpty;
            super.paint(figure, graphics, insets);
            boolean identifierNotEmpty = !TFormFigure.this.identifierCompartmentFigure.getChildren().isEmpty();
            boolean bl = attributeNotEmpty = !TFormFigure.this.attributeCompartmentFigure.getChildren().isEmpty();
            if (identifierNotEmpty || attributeNotEmpty) {
                Rectangle rect1 = TFormFigure.this.titleCompartmentFigure.getBounds();
                Rectangle rect2 = null;
                Point p = null;
                Point p2 = null;
                if (identifierNotEmpty) {
                    rect2 = TFormFigure.this.identifierCompartmentFigure.getBounds();
                    p = tempRect.getTopLeft().getCopy();
                    p.x = p.x + rect2.width + 2;
                    p.y = p.y + rect1.height + 2;
                    p2 = tempRect.getBottomLeft().getCopy();
                    p2.x = p2.x + rect2.width + 2;
                } else {
                    p = tempRect.getTopLeft().getCopy();
                    p.x += 2;
                    p.y = p.y + rect1.height + 2;
                    p2 = tempRect.getBottomLeft().getCopy();
                    p2.x += 2;
                }
                graphics.drawLine(p, p2);
            }
            if (this.notImplement) {
                graphics.drawLine(tempRect.getTopLeft(), tempRect.getBottomRight());
                graphics.drawLine(tempRect.getBottomLeft(), tempRect.getTopRight());
            }
        }
    }

    protected static class EntityLayoutCompartmentFigure
    extends Figure {
        public EntityLayoutCompartmentFigure() {
            ToolbarLayout layout = new ToolbarLayout(true);
            layout.setMinorAlignment(1);
            layout.setStretchMinorAxis(true);
            layout.setSpacing(0);
            this.setLayoutManager((LayoutManager)layout);
            this.setBorder((Border)new EntityLayoutCompartmentFigureBorder());
        }
    }

    protected static class EntityLayoutCompartmentFigureBorder
    extends AbstractBorder {
        protected EntityLayoutCompartmentFigureBorder() {
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(0, 1, 0, 1);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            if (!((IFigure)figure.getChildren().get(0)).getChildren().isEmpty() || !((IFigure)figure.getChildren().get(1)).getChildren().isEmpty()) {
                graphics.drawLine(EntityLayoutCompartmentFigureBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getTopLeft(), tempRect.getTopRight());
            }
        }
    }

    protected static class EntityTitleCompartmentFigure
    extends Figure {
        public EntityTitleCompartmentFigure() {
            this.setLayoutManager((LayoutManager)new BorderLayout());
            this.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        }

        public void setEntityName(Figure name) {
            this.add((IFigure)name);
            this.getLayoutManager().setConstraint((IFigure)name, (Object)BorderLayout.CENTER);
        }

        public void setEntityType(Figure type) {
            this.add((IFigure)type);
            this.getLayoutManager().setConstraint((IFigure)type, (Object)BorderLayout.RIGHT);
        }
    }
}

