/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.views.properties.gef3.commands;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gef.commands.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyChangeCommand
extends Command {
    private static Logger logger = LoggerFactory.getLogger(PropertyChangeCommand.class);
    private Object model;
    private String propertyName;
    private Object oldValue;
    private Object newValue;

    public PropertyChangeCommand(Object model, String propertyName, Object oldValue, Object newValue) {
        this.model = model;
        this.propertyName = propertyName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public void execute() {
        this.doExecute(this.model, this.propertyName, this.newValue);
    }

    public void undo() {
        this.doExecute(this.model, this.propertyName, this.oldValue);
    }

    private void doExecute(Object model, String propertyName, Object value) {
        try {
            BeanUtils.copyProperty((Object)model, (String)propertyName, (Object)value);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }
}

