/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.views.properties.gef3;

import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetSorter;
import org.tmdmaker.ui.views.properties.gef3.TMDEditorPropertySourceProvider;
import org.tmdmaker.ui.views.properties.gef3.commands.PropertyChangeCommand;

public class TMDPropertySheetPage
extends PropertySheetPage {
    private final CommandStack commandStack;
    private final CommandStackEventListener commandStackEventListener;

    public TMDPropertySheetPage(CommandStack commandStack) {
        this.commandStack = commandStack;
        this.commandStackEventListener = new CommandStackEventListener(){

            public void stackChanged(CommandStackEvent event) {
                if (this.executeUndoRedo(event) || this.executeNotPropertySheetCommand(event)) {
                    TMDPropertySheetPage.this.refresh();
                }
            }

            protected boolean executeNotPropertySheetCommand(CommandStackEvent event) {
                return event.getDetail() == 8 && !(event.getCommand() instanceof PropertyChangeCommand);
            }

            protected boolean executeUndoRedo(CommandStackEvent event) {
                return event.getDetail() == 32 || event.getDetail() == 16;
            }
        };
        commandStack.addCommandStackEventListener(this.commandStackEventListener);
        this.setSorter(new TMDPropertySheetSorter());
        this.setPropertySourceProvider(new TMDEditorPropertySourceProvider(this.commandStack));
    }

    public void dispose() {
        if (this.commandStack != null) {
            this.commandStack.removeCommandStackEventListener(this.commandStackEventListener);
        }
        super.dispose();
    }

    private class TMDPropertySheetSorter
    extends PropertySheetSorter {
        private TMDPropertySheetSorter() {
        }

        public void sort(IPropertySheetEntry[] entries) {
        }
    }
}

