/**
 * Title: tn5250J
 * Copyright:   Copyright (c) 2001
 * Company:
 * @author  Kenneth J. Pouncey
 * @version 0.5
 * 
 * Modified by pei DEC/2004
 * 
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j;

import java.io.*;
import java.net.*;
import java.util.Calendar;

//import org.python.modules.synchronize;

import je.tn5250j.encoding.CodePage;

public class DataStreamTracer {
	protected String fname;
	private CodePage codePage;
	private boolean dumpBytes = false;
	protected String cr = System.getProperty("line.separator");
	// add pei 070124
	protected int sessionID;
	
	// chg pei 070124 g[XɃZbVIDǉ
	//public DataStreamTracer() {
	public DataStreamTracer(int sid) {
		super();
		// add pei 070124
		sessionID= sid;
	}

	public void setFName(String fn) {
		fname= fn;
	}

	public void setDebug(boolean b) {
		dumpBytes= b;
		System.out.println("Data Stream output is now " + dumpBytes);
	}

	public void setCodePage(CodePage cp) {
		codePage = cp;
	}

	protected final void toggleDebug(CodePage cp) {

		if (codePage == null)
			codePage = cp;

		dumpBytes = !dumpBytes;
		System.out.println("Data Stream output is now " + dumpBytes);
	}

	private final String [] msgs= {
// org		"Receive data from AS/400: ",
// org		"Send Data to AS/400: "
		"Receive data from iSeries: ",
		"Send Data to iSeries: "
	};
	public void dump(byte[] abyte0, int type) {
		if (!dumpBytes)
			return;
		synchronized (this) {
			try {
				FileOutputStream fw= null;
				BufferedOutputStream dw= null;
				if (fname != null) {
					fw = new FileOutputStream(fname, true);
					dw = new BufferedOutputStream(fw);
				}
				// chg pei 070124 ZbVIDǉ
				//String msg= msgs[type] + new java.util.Date();
				String msg= msgs[type] + "Session(" + sessionID + ") " + new java.util.Date();
				System.out.println(msg);
				if (dw != null) dw.write((cr + msg).getBytes());
	
				StringBuffer h = new StringBuffer();
				int loopcnt= (abyte0.length / 16) * 16;
				if ((abyte0.length % 16) != 0) loopcnt += 16;
	//			for (int x = 0; x < abyte0.length; x++) {
				for (int x = 0; ; x++) {
					if (x % 16 == 0) {
						System.out.println("  " + h.toString());
						if (dw != null) dw.write(("  " + h.toString() + cr).getBytes());
						if (x >= loopcnt) break;
						h.setLength(0);
						h.append("+0000");
						h.setLength(5 - Integer.toHexString(x).length());
						h.append(Integer.toHexString(x).toUpperCase());
	
						System.out.print(h.toString());
						if (dw != null) dw.write(h.toString().getBytes());
	
						h.setLength(0);
					}
					char ac = ' ';
					if (x < abyte0.length) {
						byte xd= abyte0[x];
						ac= (xd >= 0 && xd < 0x40) ? '.' : codePage.ebcdic2uni(xd);
					}
					h.append(ac);
					if (x % 4 == 0) {
						System.out.print(" ");
						if (dw != null) dw.write((" ").getBytes());
	
					}
	
					if (x >= abyte0.length) {
						System.out.print("  ");
						if (dw != null) dw.write("  ".getBytes());
					} else {
						String hs= Integer.toHexString(abyte0[x] & 0xff).toUpperCase();
						if (hs.length() == 1) {
							hs= "0" + hs;
						}
						System.out.print(hs);
						if (dw != null) dw.write(hs.getBytes());
					}
	
				}
				System.out.println();
				if (dw != null) dw.write(cr.getBytes());
	
				if (dw != null) {
					dw.flush();
					dw.close();
					fw.close();
				}
			} catch (EOFException _ex) {
			} catch (Exception _ex) {
				System.out.println("Cannot dump byte array");
			}
		}
	}

}