/**
 * Title: tn5250J
 * Copyright:   Copyright (c) 2001
 * Company:
 * @author  Kenneth J. Pouncey
 * @version 0.4
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j;

import java.awt.*;
import javax.swing.*;

import java.lang.reflect.Method;
import java.util.*;
import javax.swing.plaf.*;

import je.tn5250j.interfaces.ConfigureFactory;
import je.tn5250j.interfaces.OptionAccessFactory;
import je.tn5250j.tools.LangTool;
import je.tn5250j.event.*;

public class My5250App extends JApplet implements TN5250jConstants, EmulatorActionListener {
	boolean isStandalone = true;
	private SessionManager manager;
	protected Session sess;
	protected Screen5250 screen;
	protected String signon;
	protected String signoff;

	public String ErrorMessage;
	private final static int TRC_ERROR= 1;
	private final static int TRC_WARNING= 2;
	private final static int TRC_LOG= 4;
	private final static int TRC_DEBUG= 8;
	int loglevel= 2;
	public boolean waitcancel= false;

	/**Get a parameter value*/
	public String getParameter(String key, String def) {

		return isStandalone
			? System.getProperty(key, def)
			: (getParameter(key) != null ? getParameter(key) : def);
	}

	/**Construct the applet*/
	public My5250App() {

	}
	/**Initialize the applet*/
	public void init() {
		try {
			setLAF();
			
			// add 3lines pei 070315 AvbgTABL[L
			KeyboardFocusManager kfm= KeyboardFocusManager.getCurrentKeyboardFocusManager();
			kfm.setDefaultFocusTraversalKeys(KeyboardFocusManager.FORWARD_TRAVERSAL_KEYS, Collections.EMPTY_SET);
			kfm.setDefaultFocusTraversalKeys(KeyboardFocusManager.BACKWARD_TRAVERSAL_KEYS, Collections.EMPTY_SET);
			
			jbInit();
			System.out.println("TN5250j JP V" + tn5250jRelease2 + tn5250jVersion2 + tn5250jSubVer2 + " started");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**Component initialization*/
	protected void jbInit() throws Exception {
		//      this.setSize(new Dimension(400,300));

		String propFileName= "";
		
		this.setSize(new Dimension(600, 400));
		ConfigureFactory.reset();
		OptionAccessFactory.reset();
		SessionManager.reset();
		ConfigureFactory cf= ConfigureFactory.getInstance();
		cf.reloadSettings();

		Properties pp= cf.getProperties(GlobalConfigure.SESSIONS);
		if (isSpecified("-mr")) {
			String restr= "";
			if (pp.containsKey("emul.restricted")) {
				restr= pp.getProperty("emul.restricted");
			}
			if (restr.length() != 0) restr += ";";
			restr += getParameter("-mr");
			pp.setProperty("emul.restricted", restr);
		}

		Properties sesProps = new Properties();

		sesProps.put(SESSION_APPLET, "1");
		// Start loading properties - Host must exist
		sesProps.put(SESSION_HOST, getParameter("host"));

//		if (isSpecified("-e"))
		sesProps.put(SESSION_TN_ENHANCED, "1");

		if (isSpecified("-p")) {
			sesProps.put(SESSION_HOST_PORT, getParameter("-p"));
		}

		if (isSpecified("-f"))
			propFileName = "_" + getParameter("-f") + ".prop";

		if (isSpecified("-cp"))
			sesProps.put(SESSION_CODE_PAGE, getParameter("-cp"));

		if (isSpecified("-gui"))
			sesProps.put(SESSION_USE_GUI, "1");

		if (isSpecified("-132"))
			sesProps.put(SESSION_SCREEN_SIZE, SCREEN_SIZE_27X132_STR);
		else
			sesProps.put(SESSION_SCREEN_SIZE, SCREEN_SIZE_24X80_STR);

		// socks proxy host argument
		if (isSpecified("-sph")) {
			sesProps.put(SESSION_PROXY_HOST, getParameter("-sph"));
		}

		// socks proxy port argument
		if (isSpecified("-spp"))
			sesProps.put(SESSION_PROXY_PORT, getParameter("-spp"));

		// check if device name is specified
		if (isSpecified("-dn"))
			sesProps.put(SESSION_DEVICE_NAME, getParameter("-dn"));

		if (isSpecified("-L"))
			LangTool.init(parseLocale(getParameter("-L")));
		else
			LangTool.init();

		if (isSpecified("signon")) {
			signon = getCryptoParameter("signon");
		}

		if (isSpecified("ifdebug"))
			loglevel = Integer.parseInt(getParameter("ifdebug"));
			
		if (isSpecified("signoff"))
			signoff= getParameter("signoff");
			
		loadSystemProperty("SESSION_CONNECT_USER");
		loadSystemProperty("SESSION_CONNECT_PASSWORD");
		loadSystemProperty("SESSION_CONNECT_PROGRAM");
		loadSystemProperty("SESSION_CONNECT_LIBRARY");
		loadSystemProperty("SESSION_CONNECT_MENU");

		manager = new SessionManager();
		sess = manager.openSession(sesProps, propFileName, "Test Applet");

		this.getContentPane().setLayout(new BorderLayout());
		if (!isSpecified("hideToolBar")) {
			this.getContentPane().add(new MyToolBar(sess), BorderLayout.NORTH);
		}
		this.getContentPane().add(sess, BorderLayout.CENTER);

		sess.connect();
		sess.addEmulatorActionListener(this);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				sess.grabFocus();
				screen = sess.getScreen();
				if (signon != null) {
					screen.sendKeys(signon);
				}
			}
		});

	}

	private void loadSystemProperty(String param) {

		if (isSpecified(param))
			System.getProperties().put(param, getParameter(param));

	}

	/**Get Applet information*/
	public String getAppletInfo() {
		return "tn5250j - Jave tn5250 Client";
	}

	/**Get parameter info*/
	public String[][] getParameterInfo() {
		return null;
	}

	/**
	 * Tests if a parameter was specified or not.
	 */
	protected boolean isSpecified(String parm) {

		if (getParameter(parm) != null) {
			System.out.println("Parameter " + parm + " is specified");
			System.out.println("Parameter=" + getParameter(parm));
			return true;
		}
		return false;
	}

	/**
	 * Returns a local specified by the string localString
	 */
	protected static Locale parseLocale(String localString) {
		int x = 0;
		String[] s = { "", "", "" };
		StringTokenizer tokenizer = new StringTokenizer(localString, "_");
		while (tokenizer.hasMoreTokens()) {
			s[x++] = tokenizer.nextToken();
		}
		return new Locale(s[0], s[1], s[2]);
	}

	public void destroy() {
		if (signoff != null) {
			screen.sendKeys(signoff);
			waitInput();
		}
		sess.getScreen().stopBlinker();
		sess.disconnect();
		System.out.println("destroy");
	}


	/*  Ohe */
	
	/**
	 * sw̓Ǎ
	 * @return java.lang.String Ǎf[^
	 * @param row int s P`
	 * @param clm int  P`
	 * @param len int PSoCg
	 */
	public String readText(int row, int clm, int len) {
		String rets= null;
		trace("readText called", TRC_DEBUG);
		ErrorMessage= "";
		char [] data= new char[len+1];
		try {
			int rlen= screen.getString(data, row, clm, len);
			rets= new String(data, 0, rlen);
		}
		catch (Exception e) {
			trace("ʓǍɈُ킪܂: " + e, TRC_ERROR);
		}
		trace("readText return : " + rets, TRC_DEBUG);
		return (rets);
	}
	
	/**
	 * sw̏
	 * @return int 0: OK  -1: ERROR
	 * @param data java.lang.String ݃f[^
	 * @param row int s P`@(0̎@݃J[\ʒu)
	 * @param clm int  P`
	 */
	public int writeText(String data, int row, int clm) {
		int retc= 0;
		trace("writeText called", TRC_DEBUG);
		ErrorMessage= "";
		try {
			if (row != 0) {
				screen.goto_XY_with_C((row - 1) * screen.getCols() + clm - 1);
			}
			screen.sendKeys(data);
		}
		catch (Exception e) {
			trace("ʏɈُ킪܂:" + e, TRC_ERROR);
			retc= -1;
		}
		trace("writeText return : " + retc, TRC_DEBUG);
		
		return (retc);
	}
	
	/**
	 * ʌ
	 * @return boolean  true: OK  false: NG
	 * @param dt java.lang.String
	 * @param row int s P`
	 * @param clm int  P`
	 */
	public boolean ps_check(String dt, int row, int clm) {
		boolean retv= true;
		try {
			if (dt.length() != 0) {
				retv= dt.equals(readText(row, clm, dt.getBytes().length));
			}
		} catch (Exception e) {
			trace("ʌɈُ킪܂: " + e, TRC_ERROR);
			return (false);
		}
		return (retv);
	}

	/**
	 * ʑ҂
	 * @return boolean  true: OK  false: NG
	 * @param dt java.lang.String
	 * @param row int s P`
	 * @param clm int  P`
	 * @param sec int ҂(b)@(0̎)
	 */
	public boolean psWait(String dt, int row, int clm, int sec) {
		trace("psWait called", TRC_DEBUG);
		waitInput();
		waitcancel= false;
		boolean ret= ps_check(dt, row, clm);
		int c= 0;
		int lc= sec * 2;
		try {
			while (!ret && (sec == 0 || c < lc) && !waitcancel) {
				Thread.sleep(500);
				waitInput();
				ret= ps_check(dt, row, clm);
				++c;
			}
		} catch (Exception e) {
			trace("ʌɈُ킪܂: " + e, TRC_ERROR);
			return (false);
		}
		trace("psWait return:" + ret, TRC_DEBUG);
		return (ret);
	}

	/**
	 * ʑ҂ 
	 */
	public void psWaitCancel() {
		waitcancel= true;
	}

	/**
	 * ͉҂
	 * @return boolean
	 */
	public boolean waitInput() {
		trace("waitInput called", TRC_DEBUG);
		// chg pei 060901
		//boolean ret= screen.waitInput();
		boolean ret= screen.waitInput(10000);
		trace("waitInput return:" + ret, TRC_DEBUG);
		return (ret);
	}

	/**
	 * Oo
	 * @param msg java.lang.String
	 * @param level int
	 */
	private void trace(String msg, int level) {
		if (level == TRC_ERROR) {
			ErrorMessage= msg;
		}
		if (level > loglevel) return;
		System.out.println(msg);
	}

	/**
	 * O
	 * @param data java.lang.String
	 * @param mode int 0:f[^̂݁@1:݂̉ʕt
	 */
	public void writeLog(String data, int mode) {
		java.util.Date tm= new java.util.Date();
		System.out.println(tm.toString() + ": LOG DATA=[" + data + "]");
		if (mode != 0) {
			int row= screen.getRows();
			int col= screen.getCols();
			char [] bf= new char[col];
			for (int i= 1; i <= row; ++i) {
				int rlen= screen.getString(bf, i, 1, col);
				System.out.println(new String(bf, 0, rlen));
			}
		}
	}
	
	protected String getCryptoParameter(String p) {
		String retv= getParameter(p);
		if (isSpecified("crypto")) {
			try {
				String encrypto= getParameter("crypto");
				Object o= Class.forName(encrypto).newInstance();
				Method	m= o.getClass().getMethod("decrypt", new Class[] {retv.getClass()});
				retv= (String) m.invoke(o, new Object [] {retv});
			} catch (Exception e) {
				System.out.println("decrypt failed:" + e);
			}
		}
		return (retv);
	}
	
	//setting look & feel
	protected void setLAF() {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			//UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
//add 4 lines by pei JUL/2005
			Font font = new Font(DEFAULT_FONT, Font.PLAIN, 12);
			FontUIResource fontUIResource = new FontUIResource(font);
			UIManager.put("TextField.font", fontUIResource);
			UIManager.put("ComboBox.font", fontUIResource);
		} catch (Exception e) {
		}
	}
	
	// add pei 070124 ApplettH[JXΉ
	public void getFocus(){

		JFrame jf = new JFrame();
		MyDialog md = new MyDialog(jf);
		md.show();
		md.requestFocus();
		md.hide();
		
		sess.getFocusForMe();
	}

	// add pei 071127 Applet̍ĐڑT|[g
	public void onEmulatorAction(EmulatorActionEvent actionEvent) {

		Session ses = (Session) actionEvent.getSource();

		switch (actionEvent.getAction()) {
			case EmulatorActionEvent.RESTART_SESSION : //pei
				ses.connect();
				break;
		}
	}

}

class MyDialog extends JDialog {
	MyDialog(JFrame jf) {
		super(jf);
		setTitle("");
		setSize(1, 1);
		setLocation(-100,-100);
		setVisible(true);
	}	
}