/**
 * Title: tn5250J
 * Copyright:   Copyright (c) 2001
 * Company:
 * @author  Kenneth J. Pouncey
 * @version 0.4
 * 
 * Modified by pei DEC/2004
 * 
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Added NOV/2005 By pei
 */
package je.tn5250j;

public class ScrollBarField extends ScreenField {
	private int flag;
	private int totalRowScrollable;
	private int totalColScrollable;
	private int sliderRowPos;
	private int sliderColPos;
	private int sbSize;

	protected ScrollBarField(Screen5250 s) {
		super(s);
	}

	public int getType() {
		return (ScreenField.F_SCROLLBAR);
	}

	public void setParam(int p1, int p2, int p3, int p4, int p5, int p6) {
		flag= p1;
		totalRowScrollable= p2;
		totalColScrollable= p3;
		sliderRowPos= p4;
		sliderColPos= p5;
		sbSize= p6;
	}	

	public int getFlag() {
		return (flag);
	}	

	public int getTotalRowScrollable() {
		return (totalRowScrollable);
	}	

	public int getTotalColScrollable() {
		return (totalColScrollable);
	}	

	public int getSliderRowPos() {
		return (sliderRowPos);
	}	

	public int getSliderColPos() {
		return (sliderColPos);
	}	

	public int getSBSize() {
		return (sbSize);
	}	

	public boolean isFirstRow(int row) {
		return (row == (this.frow + 1));
	}

	public int getMin() {
		return (this.frow + 1);
	}

	public int getMax() {
		return (this.frow + sbSize - 2);
	}

	public int getCpr() {
		return ((int) ((float)totalColScrollable / ((float)sbSize - 2) + 0.5));
	}

	// add pei 080208
	public boolean isList() {
		return ((flag & 0x100) != 0);
	}

}