/**
 * Title: tn5250J
 * Copyright:   Copyright (c) 2001
 * Company:
 * @author  Kenneth J. Pouncey
 * @version 0.4
 * 
 * Modified by pei DEC/2004
 * 
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Added NOV/2005 By pei
 */
package je.tn5250j;

import java.io.*;

public class SelectionField extends ScreenField {
//	protected int selectpos= 0;
	boolean [] available;
	protected int flag1, flag2, flag3;
	protected int type;
	protected int [] choice_pos;
	protected int [] choice_len;
	protected int [][] minor_flag;
	protected int maxcolchoice;
	protected int right_max= 0;
	protected boolean [] selected;

	protected SelectionField(Screen5250 s, int t) {
		super (s);
		type= t;
	}

	protected ScreenField setField(
		int attr,
		int row,
		int col,
		int len,
		int rs,
		int ffw1,
		int ffw2,
		int fcw1,
		int fcw2) {
//		super.setField(attr, row, col, len, rs, ffw1, ffw2, fcw1, fcw2);
//		available= new boolean[rs];
		minor_flag= new int[3][];
//		minor_flag[0]= new int[rs];
//		minor_flag[1]= new int[rs];
//		minor_flag[2]= new int[rs];
		return (super.setField(attr, row, col, len, rs, ffw1, ffw2, fcw1, fcw2));
	}
	
	public int getType() {
		return (type);
	}
	
	public boolean isCField() {
		return (true);
	}

	public void setSelectPos(int p) {
		if (p == 0) {
			reset();
			return;
		}
		--p;
		try {
			boolean b= !selected[p];
			if (type != ScreenField.F_MULTISELECTION) {
				reset();
			}
			selected[p]= type == ScreenField.F_MENU ? true : b;
		} catch (ArrayIndexOutOfBoundsException e) {
		}
		mdt= true;
	}	

	public void reset() {
		for (int i= 0; i < selected.length; ++i) {
			selected[i]= false;
		}
	}	

	public void setAvailable(int p, boolean f) {
		available[p - 1]= f;
	}	

	public boolean isSelected(int p) {
		return (selected[p - 1]);
	}

	public boolean isAvalilable(int pos) {
		return (available[pos - 1]);
	}

	public boolean withinField(int pos) {
		if (type == ScreenField.F_MENU) {
//			return (s.getRow(pos) == startRow() && pos >= s.getCol(startPos));
			return (startPos <= pos && pos < (choice_pos[choice_pos.length - 1] + choice_len[choice_pos.length - 1]));
		}
		int wc= startPos;
		int col_left= startPos - 3;
//		int col_right= startPos + length;
		int col_right= startPos + right_max;
		
		for (int i= 0; i < rows; ++i) {
			if (pos >= col_left && pos <= col_right) {
				return true;
			}
			col_left += s.getCols();
			col_right += s.getCols();
		}
		return false;

	}

	public void setFlag(int f1, int f2, int f3) {
		flag1= f1;
		flag2= f2;
		flag3= f3;
	}
	
	public void setMaxColChoice(int n) {
		maxcolchoice= n;
		int nn= n * rows;
		available= new boolean[nn];
		choice_pos= new int[nn];
		choice_len= new int[nn];
		minor_flag[0]= new int[nn];
		minor_flag[1]= new int[nn];
		minor_flag[2]= new int[nn];
		selected= new boolean[nn];
	}
	
	public int getMaxColChoice() {
		return (maxcolchoice);
	}
	
	public int getChoice_cnt() {
		return (choice_pos.length);
	}
	
	public void setChoice_pos(int n, int p, int l) {
		choice_pos[n - 1]= p;
		choice_len[n - 1]= l;
		int rm= ((p + l) % s.getCols()) - startCol();
		if (right_max < rm) right_max= rm;
	}
	
	public int getChoice_pos(int n) {
		return (choice_pos[n - 1]);
	}
	
	public int getChoice_len(int n) {
		return (choice_len[n - 1]);
	}
	
	public int getFlag1() {
		return (flag1);
	}
	
	public int getFlag2() {
		return (flag2);
	}
	
	public int getFlag3() {
		return (flag3);
	}
	
	public void advancePos(boolean dir) {
		int selectpos= get1SelectedPos();
		selected[selectpos]= false;
		if (dir) {
			++selectpos;
			if (selectpos >= choice_pos.length) {
				selectpos= 0;
			}
		} else {
			--selectpos;
			if (selectpos < 0) {
				selectpos= choice_pos.length - 1;
			}
		}
		selected[selectpos]= true;
	}
	
	public int getSingleSelectedPos() {
		return (get1SelectedPos() + 1);
	}
	
	private int get1SelectedPos() {
		for (int i= 0; i < selected.length; ++i) {
			if (selected[i]) return (i);
		}
		return (-1);
	}
	
	public boolean changeMenu(int cellpos) {
		for (int i= 0; i < choice_pos.length; ++i) {
			if (cellpos >= choice_pos[i] && cellpos < (choice_pos[i] + choice_len[i])) {
				reset();
				selected[i]= true;
				return (true);
			}
		}
		return (false);
	}
	
	public void setMinorFlags(int n, int f1, int f2, int f3) {
		minor_flag[0][n - 1]= f1;
		minor_flag[1][n - 1]= f2;
		minor_flag[2][n - 1]= f3;
	}

	public int getMinorFlag(int n, int nn) {
		return (minor_flag[n - 1][nn == 0 ? 0 : nn - 1]);
	}
	
	public boolean isSelectionField() {
		return (true);
	}
	
	public int getChoice(int pos) {
		for (int i= 0; i < choice_pos.length; ++i) {
			int l= choice_len[i] == 0 ? right_max : choice_len[i];
//			if ((choice_pos[i] - 3) <= pos && pos <= (choice_pos[i] + choice_len[i])) return (i + 1);
			if ((choice_pos[i] - 3) <= pos && pos <= (choice_pos[i] + l)) return (i + 1);
		}
		return (-1);
	}
	
	public void readData(ByteArrayOutputStream baosp) {
		baosp.write(17); // start of field data
		baosp.write(startRow() + 1);
		baosp.write(startCol() + 1);
		if (type == ScreenField.F_MULTISELECTION) {
			for (int i= 0; i < selected.length; ++i) {
				baosp.write((byte)(selected[i] ? 0xf1: 0));
			}
		} else {
			int spos= get1SelectedPos() + 1;
					
			// chg pei 060831
			//spos += 0x1f;
			if (spos != 0) {
				spos += 0x1f;
			}
					
			baosp.write((byte)(spos >> 8));
			baosp.write((byte)spos);
			if (type == ScreenField.F_SINGLESELECTION_LIST) {
				baosp.write((byte)0);
				baosp.write((byte)0);
				baosp.write((byte)0);
				baosp.write((byte)0);
			}
		}
	}
	
	public int c_up(int n, int cur) {
		if (rows == 1) return (n);
		int pos= getChoice(cur);
		if (pos == -1) return (n);
		int lpos= (pos - 1) / maxcolchoice;
		++lpos;
		if (lpos > 1) {
			do {
				pos -= maxcolchoice;
				--lpos;
			} while (lpos > 1 && !isAvalilable(pos));
			int np= getChoice_pos(pos);
			return (np - cur);
		}
		return (n);
	}
	
	public int c_down(int n, int cur) {
		if (rows == 1) return (n);
		int pos= getChoice(cur);
		if (pos == -1) return (n);
		int lpos= (pos - 1) / maxcolchoice;
		++lpos;
		if (lpos < rows) {
			do {
				pos += maxcolchoice;
				++lpos;
			} while (lpos < rows && !isAvalilable(pos));
			int np= getChoice_pos(pos);
			return (np - cur);
		}
		return (n);
	}
	
	public int c_left(int n, int cur) {
		int pos= getChoice(cur);
		if (pos == -1) return (n);
		if (maxcolchoice == 1 || (pos % maxcolchoice) == 1) return (getChoice_pos(pos) - 4 - cur);
		if (pos > 1) {
			--pos;
			int np= getChoice_pos(pos);
			return (np - cur);
		}
		return (n);
	}
	
	public int c_right(int n, int cur) {
		int pos= getChoice(cur);
		if (pos == -1) return (n);
		if (maxcolchoice == 1) return(getChoice_pos(pos) + right_max + 1 - cur);
		if ((pos % maxcolchoice) == 0) return(getChoice_pos(pos) + getChoice_len(pos) + 1 - cur);
		if (pos < maxcolchoice) {
			++pos;
			int np= getChoice_pos(pos);
			return (np - cur);
		}
		return (n);
	}
	
}