/**
 * Title: CodePage.java
 * Copyright:   Copyright (c) 2001, 2002, 2003
 * Company:
 * @author  Kenneth J. Pouncey
 *          rewritten by LDC, WVL, Luc
 * @version 0.4
 * 
 * Modified by pei DEC/2004
 * 
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j.encoding;

/**
 *
 * This class controls the translation from EBCDIC to ASCII and ASCII to EBCDIC
 *
 */
public abstract class CodePage
{
	public boolean nuse_small= false;	//pei
	public boolean uni_ext= false;	//pei
  protected CodePage(String encoding)
  {
    this.encoding = encoding;
  }

  public abstract char ebcdic2uni (int index);
  public abstract char ebcdic2unik (int index1, int index2);
//  public abstract byte [] uni2ebcdic (char index);
  public abstract byte [] uni2ebcdic (char index, boolean dbcf);
  public abstract boolean available (char c);
  // add pei 080312
  public abstract String getCodePage();
  public abstract String getCharSet();
  public abstract String getKBDType();

  public String getEncoding ()
  {
     return encoding;
  }

  protected String encoding;
}
