/**
 * Title: KeypadAttributesPanel
 * Copyright:   Copyright (c) 2001
 * Company:
 * @author  Kenneth J. Pouncey
 * @version 0.5
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Added SEP/2005 By pei
 */
package je.tn5250j.settings;

import java.awt.*;
import javax.swing.*;

import je.tn5250j.tools.*;
import je.tn5250j.SessionConfig;

public class IMEControlAttributesPanel extends AttributesPanel {

	JCheckBox imeCheck;
	final String kwd= "imecontrol";

	public IMEControlAttributesPanel(SessionConfig config) {
		super(config, "IME");
	}

	/**Component initialization*/
	public void initPanel() throws Exception {

		setLayout(new BorderLayout());
		contentPane = new JPanel();
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
		add(contentPane, BorderLayout.NORTH);

		// define IME Control panel
		JPanel imep = new JPanel();
		imep.setBorder(
			BorderFactory.createTitledBorder(LangTool.getString("sa.imep")));
		imeCheck = new JCheckBox(LangTool.getString("sa.imeCheck"));

		String kwdp= getStringProperty(kwd);
		if (kwdp.length() == 0 || kwdp.equals("Yes"))
			imeCheck.setSelected(true);

		imep.add(imeCheck);

		contentPane.add(imep);

	}

	public void save() {

	}

	public boolean applyAttributes() {

		if (imeCheck.isSelected()) {
			changes.firePropertyChange(
				this,
				kwd,
				getStringProperty(kwd),
				"Yes");
			setProperty(kwd, "Yes");
		} else {
			changes.firePropertyChange(
				this,
				kwd,
				getStringProperty(kwd),
				"No");
			setProperty(kwd, "No");
		}
		return (true);
	}
}