/*
 * @(#)X509CertificateTrustManager.java
 *
 * Copyright:    Copyright (c) 2001
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j.transport.SSL;

import javax.net.ssl.X509TrustManager;
import java.security.cert.X509Certificate;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.swing.JOptionPane;
import je.tn5250j.tools.LangTool;

public class X509CertificateTrustManager implements X509TrustManager {

	KeyStore ks = null;
	X509TrustManager trustManager = null;
	String ks_file;
	String ks_pass;

	public X509CertificateTrustManager(
		X509TrustManager manager,
		KeyStore keyStore,
		String ks_f,
		String ks_p) {
		trustManager = manager;
		ks = keyStore;
		ks_file = ks_f;
		ks_pass = ks_p;
	}

	public void checkClientTrusted(X509Certificate[] chain, String type)
		throws java.security.cert.CertificateException {

	}
	public void checkServerTrusted(X509Certificate[] chain, String type)
		throws java.security.cert.CertificateException {
		try {
			trustManager.checkServerTrusted(chain, type);
			return;
		} catch (CertificateException ce) {
			System.out.println("trust:" + ce);
			X509Certificate cert = chain[0];
			String certInfo = "Version: " + cert.getVersion() + "\n";
			certInfo =
				certInfo.concat(
					"Serial Number: " + cert.getSerialNumber() + "\n");
			certInfo =
				certInfo.concat(
					"Signature Algorithm: " + cert.getSigAlgName() + "\n");
			certInfo =
				certInfo.concat(
					"Issuer: " + cert.getIssuerDN().getName() + "\n");
			certInfo =
				certInfo.concat("Valid From: " + cert.getNotBefore() + "\n");
			certInfo =
				certInfo.concat("Valid To: " + cert.getNotAfter() + "\n");
			certInfo =
				certInfo.concat(
					"Subject DN: " + cert.getSubjectDN().getName() + "\n");
			certInfo =
				certInfo.concat(
					"Public Key: " + cert.getPublicKey().getFormat() + "\n");

			int accept =
				JOptionPane.showOptionDialog(
					null,
					LangTool.getString("ssl.accept.certificate") + "\n" + certInfo,
					LangTool.getString("ssl.accept.win"),
					javax.swing.JOptionPane.YES_NO_CANCEL_OPTION,
					javax.swing.JOptionPane.QUESTION_MESSAGE,
					null,
					new String [] {LangTool.getString("ssl.accept.yes"),
						LangTool.getString("ssl.accept.save"),
						LangTool.getString("ssl.accept.no")},
						null);
			if (accept == 2) {
				throw new java.security.cert.CertificateException(
					"Certificate Not Accepted");
			}
			else if (accept == 1) {
				try {
					String alias = null;
					for (int i = 0; i < 100; ++i) {
						alias = "je5250_" + i;
						if (!ks.containsAlias(alias))
							break;
					}
					ks.setCertificateEntry(alias, cert);
					ks.store(new FileOutputStream(ks_file), ks_pass.toCharArray());
				} catch (Exception e) {
					System.out.println(e.toString());
				}
			}
		}
	}

	public X509Certificate[] getAcceptedIssuers() {
		return trustManager.getAcceptedIssuers();
	}
}